!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE GETSPINEZERO

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPINARRAY

  IMPLICIT NONE

  INTEGER :: I, J, K, MYINDEX
  REAL(LATTEPREC) :: DSPINS, DSPINP

  ESPIN_ZERO = ZERO
  MYINDEX = 0

  DO I = 1, NATS

     DO K = 1, NOELEM

        IF (ATELE(I) .EQ. ELE(K)) THEN

           IF (BASIS(K) .EQ. "ss") THEN

              MYINDEX = MYINDEX + 1
              DSPINS = RHOUPZERO(MYINDEX) - RHODOWNZERO(MYINDEX)

              ESPIN_ZERO = ESPIN_ZERO + WSS(K)*DSPINS*DSPINS

           ELSEIF (BASIS(K) .EQ. "sp") THEN

              MYINDEX = MYINDEX + 1

              DSPINS = RHOUPZERO(MYINDEX) - RHODOWNZERO(MYINDEX)

              DSPINP = ZERO

              DO J = 1, 3
                 
                 MYINDEX = MYINDEX + 1
                 
                 DSPINP = DSPINP + RHOUPZERO(MYINDEX) - RHODOWNZERO(MYINDEX)

              ENDDO

              ESPIN_ZERO = ESPIN_ZERO + WSS(K)*DSPINS*DSPINS + &
                   TWO*WSP(K)*DSPINS*DSPINP + &
                   WPP(K)*DSPINP*DSPINP

           ENDIF

        ENDIF

     ENDDO

  ENDDO

  ESPIN_ZERO = HALF*ESPIN_ZERO
              
  RETURN

END SUBROUTINE GETSPINEZERO
