!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE INITFERMISPARSE

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE FERMICOMMON
  USE SPARSEIND
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, M
  REAL(LATTEPREC) ::  ONEOVERKT, BOVER2M

  M = 6 

  ONEOVERKT = ONE/KBT
  BOVER2M = ONEOVERKT/(TWO**(2+M))

  DO I = 1, HDIM
     DO J = I, HDIM
        
        IF ( I .EQ. J ) THEN
           
           BO(I,I) = HALF - BOVER2M*(H(I,I) - CHEMPOT)
           
        ELSE
           
           BO(J,I) = MINUSONE*BOVER2M*H(J,I)
           BO(I,J) = BO(J,I)
           
        ENDIF
        
     ENDDO
  ENDDO

  CALL FERMIALLOCATE

  DO I = 1, 1
     CALL SOLVEMATLAPACK
  ENDDO

  CALL FERMIDEALLOCATE

  CALL BUILDSPARSELIST 

  RETURN

END SUBROUTINE INITFERMISPARSE
