SUBROUTINE INITSHOCKCOMP

  USE CONSTANTS_MOD
  USE MDARRAY

  IMPLICIT NONE

  ! First convert units of Up and Us from m/s to A/fs

  UPARTICLE = UPARTICLE*1.0D-5
  USHOCK = USHOCK*1.0D-5

  !
  ! The duration of the shock, i.e., the time taken for the 
  ! shock front to traverse the simulation cell is t_dur = l_0/Us
  !
  ! So... we'll start the Hugoniostat at timestep SHOCKSTART and 
  ! turn it off INT(L_O/(U_s *dt)) time steps later
  !

  SHOCKSTOP = SHOCKSTART + &
       INT((BOX(2,SHOCKDIR) - BOX(1,SHOCKDIR))/(USHOCK * DT))

!  PRINT*, "start, stop = ", SHOCKSTART, SHOCKSTOP

END SUBROUTINE INITSHOCKCOMP
  
