!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE NEBLISTS(AMIALLO)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE GSPARRAY
  USE PPOTARRAY
  USE NEBLISTARRAY
  USE COULOMBARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, K, L, M, N
  INTEGER :: II, JJ, KK
  INTEGER, ALLOCATABLE :: TMP(:,:,:)
  INTEGER :: AMIALLO
  INTEGER :: XRANGE, YRANGE, ZRANGE, MAXSIZE(3)
  REAL(LATTEPREC) :: RCUTTB, RCUTPP, RCUTCOUL
  REAL(LATTEPREC) :: RCUTTB2, RCUTPP2, RCUTCOUL2
  REAL(LATTEPREC) :: RIJ(3), MAGR2
  REAL(LATTEPREC) :: BOXDIMS(3)
  REAL(LATTEPREC), PARAMETER :: MINR = 0.01D0

  IF (AMIALLO .NE. 0) THEN
     DEALLOCATE (NEBTB, NEBPP)
     IF (ELECTRO .EQ. 1) THEN
        DEALLOCATE (NEBCOUL)
     ENDIF
  ENDIF

  IF (BOXON .EQ. 0) THEN
     CALL PBC
  ENDIF

  TOTNEBTB = 0
  TOTNEBPP = 0
  IF (ELECTRO .EQ. 1) THEN
     TOTNEBCOUL = 0
  ENDIF

  IF (AMIALLO .EQ. 0) THEN

     ! These are reasonable numbers of neighbors

     MAXDIMTB = 30
     MAXDIMPP = 30
     MAXDIMCOUL = 400

  ENDIF

  ALLOCATE (NEBTB(NATS,MAXDIMTB,4), NEBPP(NATS,MAXDIMPP,4))
  IF (ELECTRO .EQ. 1) THEN
     ALLOCATE(NEBCOUL(NATS,MAXDIMCOUL,4))
  ENDIF

  DO I = 1, 3
     BOXDIMS(I) = BOX(2,I) - BOX(1,I)
  ENDDO

  MAXSIZE = 0

  DO I = 1, NATS
     DO J = 1, NATS

        !
        ! Got to figure out which atoms are within the 
        ! various cut-offs for the bond integrals and 
        ! pair potentials
        !
        
        RCUTTB = ZERO

        DO K = 1, NOINT
           
           IF ((ATELE(I) .EQ. ELE1(K) .AND. &
                ATELE(J) .EQ. ELE2(K)) .OR. & 
                (ATELE(J) .EQ. ELE1(K) .AND. &
                ATELE(I) .EQ. ELE2(K))) THEN   

              ! 
              ! Since each bond integral for a given element
              ! pair can have a different cut off, we will 
              ! make sure we choose the largest when building the
              ! neighbor list
              !

              IF (GSPRCUT(K) .GT. RCUTTB) THEN
                 RCUTTB = GSPRCUT(K)
              ENDIF
              
           ENDIF

        ENDDO

        RCUTTB = RCUTTB + SKIN
        RCUTTB2 = RCUTTB*RCUTTB
        
        DO K = 1, NOPPS
           
           IF ((ATELE(I) .EQ. PPELE1(K) .AND. &
                ATELE(J) .EQ. PPELE2(K)) .OR. & 
                (ATELE(J) .EQ. PPELE1(K) .AND. &
                ATELE(I) .EQ. PPELE2(K))) THEN   
              
              RCUTPP = PPRCUT(K) + SKIN
              RCUTPP2 = RCUTPP * RCUTPP
              
           ENDIF
           
        ENDDO
        
        RCUTCOUL = COULCUT + SKIN
        RCUTCOUL2 = RCUTCOUL * RCUTCOUL
        
        ! 
        ! Do the H-matrix neighbor list
        !
        
        XRANGE = INT( RCUTTB/BOXDIMS(1) ) + 1
        YRANGE = INT( RCUTTB/BOXDIMS(2) ) + 1
        ZRANGE = INT( RCUTTB/BOXDIMS(3) ) + 1

        ! Looping over the neighboring boxes
        
        DO II = -XRANGE, XRANGE
           DO JJ = -YRANGE, YRANGE
              DO KK = -ZRANGE, ZRANGE
                 
                 RIJ(1) = CR(1,J) + FLOAT(II)*BOXDIMS(1) - CR(1,I)
                 RIJ(2) = CR(2,J) + FLOAT(JJ)*BOXDIMS(2) - CR(2,I)
                 RIJ(3) = CR(3,J) + FLOAT(KK)*BOXDIMS(3) - CR(3,I)
                 
                 MAGR2 = RIJ(1)*RIJ(1) + RIJ(2)*RIJ(2) + RIJ(3)*RIJ(3)
                 
                 IF (MAGR2 .LE. RCUTTB2 .AND. MAGR2 .GT. MINR) THEN
                    
                    TOTNEBTB(I) = TOTNEBTB(I) + 1

                    IF (TOTNEBTB(I) .GT. MAXSIZE(1)) THEN
                       MAXSIZE(1) = TOTNEBTB(I)
                    ENDIF
                    
                    IF (TOTNEBTB(I) .GT. MAXDIMTB) THEN

       !                 PRINT*, "Increase in size of TB neighbor table"
                       
                       ALLOCATE(TMP(NATS, MAXDIMTB, 4))
                       
                       MAXDIMTB = TOTNEBTB(I)
                       
                       TMP = NEBTB
                       
                       DEALLOCATE(NEBTB)
                       
                       ALLOCATE(NEBTB(NATS, MAXDIMTB, 4))
                       
                       DO L = 1, I
                          DO M = 1, MAXDIMTB - 1
                             DO N = 1, 4
                                NEBTB(L,M,N) = TMP(L,M,N)
                             ENDDO
                          ENDDO
                       ENDDO
                       
                       DEALLOCATE(TMP)
                       
                    ENDIF
                    
                    NEBTB(I,TOTNEBTB(I),1) = J
                    NEBTB(I,TOTNEBTB(I),2) = II
                    NEBTB(I,TOTNEBTB(I),3) = JJ
                    NEBTB(I,TOTNEBTB(I),4) = KK
                    
                 ENDIF

              ENDDO
           ENDDO
        ENDDO

        !
        ! Now the neighbor list for the pair potential
        !
        
        XRANGE = INT( RCUTPP/BOXDIMS(1) ) + 1
        YRANGE = INT( RCUTPP/BOXDIMS(2) ) + 1
        ZRANGE = INT( RCUTPP/BOXDIMS(3) ) + 1
        
        ! Looping over the neighboring boxes

        DO II = -XRANGE, XRANGE
           DO JJ = -YRANGE, YRANGE
              DO KK = -ZRANGE, ZRANGE
                 
                 RIJ(1) = CR(1,J) + FLOAT(II)*BOXDIMS(1) - CR(1,I)
                 RIJ(2) = CR(2,J) + FLOAT(JJ)*BOXDIMS(2) - CR(2,I)
                 RIJ(3) = CR(3,J) + FLOAT(KK)*BOXDIMS(3) - CR(3,I)
                    
                 MAGR2 = RIJ(1)*RIJ(1) + RIJ(2)*RIJ(2) + RIJ(3)*RIJ(3)     
   
                 IF (MAGR2 .LE. RCUTPP2 .AND. MAGR2 .GT. MINR) THEN
                    
                    TOTNEBPP(I) = TOTNEBPP(I) + 1

                    IF (TOTNEBPP(I) .GT. MAXSIZE(2)) THEN
                       MAXSIZE(2) = TOTNEBPP(I)
                    ENDIF
                    
                    IF (TOTNEBPP(I) .GT. MAXDIMPP) THEN
                       
                       ALLOCATE(TMP(NATS,MAXDIMPP, 4))
                       
                       MAXDIMPP = TOTNEBPP(I)

!                       print*, MAXDIMPP

                       TMP = NEBPP
                       
                       DEALLOCATE(NEBPP)
                       
                       ALLOCATE(NEBPP(NATS, MAXDIMPP, 4))
                       
                       DO L = 1, I
                          DO M = 1, MAXDIMPP - 1 
                             DO N = 1, 4
                                NEBPP(L,M,N) = TMP(L,M,N)
                             ENDDO
                          ENDDO
                       ENDDO
                       
                       DEALLOCATE(TMP)
                       
                    ENDIF
                    
                    NEBPP(I,TOTNEBPP(I),1) = J 
                    NEBPP(I,TOTNEBPP(I),2) = II 
                    NEBPP(I,TOTNEBPP(I),3) = JJ
                    NEBPP(I,TOTNEBPP(I),4) = KK
                    
                 ENDIF
                 
              ENDDO
           ENDDO
        ENDDO
        
        IF (ELECTRO .EQ. 1) THEN
           
           XRANGE = INT( RCUTCOUL/BOXDIMS(1) ) + 1
           YRANGE = INT( RCUTCOUL/BOXDIMS(2) ) + 1
           ZRANGE = INT( RCUTCOUL/BOXDIMS(3) ) + 1
           
           ! Looping over the neighboring boxes
           
           DO II = -XRANGE, XRANGE
              DO JJ = -YRANGE, YRANGE
                 DO KK = -ZRANGE, ZRANGE
                    
                    RIJ(1) = CR(1,J) + FLOAT(II)*BOXDIMS(1) - CR(1,I)
                    RIJ(2) = CR(2,J) + FLOAT(JJ)*BOXDIMS(2) - CR(2,I)
                    RIJ(3) = CR(3,J) + FLOAT(KK)*BOXDIMS(3) - CR(3,I)
                    
                    MAGR2 = RIJ(1)*RIJ(1) + RIJ(2)*RIJ(2) + RIJ(3)*RIJ(3) 

                    IF (MAGR2 .LE. RCUTCOUL2 .AND. MAGR2 .GT. MINR) THEN
                       
                       TOTNEBCOUL(I) = TOTNEBCOUL(I) + 1

                       IF (TOTNEBCOUL(I) .GT. MAXSIZE(3)) THEN
                          MAXSIZE(3) = TOTNEBCOUL(I)
                       ENDIF
                          
                       IF (TOTNEBCOUL(I) .GT. MAXDIMCOUL) THEN
                             
                          ALLOCATE(TMP(NATS, MAXDIMCOUL, 4))
                          
                          MAXDIMCOUL = TOTNEBCOUL(I)

                          TMP = NEBCOUL
                          
                          DEALLOCATE(NEBCOUL)
                          
                          ALLOCATE(NEBCOUL(NATS, MAXDIMCOUL, 4))
                          
                          DO L = 1, I
                             DO M = 1, MAXDIMCOUL - 1
                                DO N = 1, 4
                                   NEBCOUL(L,M,N) = TMP(L,M,N)
                                ENDDO
                             ENDDO
                          ENDDO
                          
                          DEALLOCATE(TMP)
                          
                       ENDIF
                       
                       NEBCOUL(I,TOTNEBCOUL(I),1) = J
                       NEBCOUL(I,TOTNEBCOUL(I),2) = II
                       NEBCOUL(I,TOTNEBCOUL(I),3) = JJ
                       NEBCOUL(I,TOTNEBCOUL(I),4) = KK
                       
                    ENDIF
                    
                 ENDDO
              ENDDO
           ENDDO
           
        ENDIF
           
     ENDDO
  ENDDO

  ! Let's get the dimensions of the arrays about right for the next
  ! loop through here
   
  MAXDIMTB = MAXSIZE(1)
  MAXDIMPP = MAXSIZE(2)
  MAXDIMCOUL = MAXSIZE(3)

!  PRINT*, MAXSIZE(1), MAXSIZE(2), MAXSIZE(3)

  RETURN

END SUBROUTINE NEBLISTS
