!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE PLOTGSP

  USE CONSTANTS_MOD
  USE GSPARRAY
  USE SETUPARRAY
  USE MYPRECISION

  IMPLICIT NONE
  
  INTEGER :: IGS, I, J
  INTEGER, PARAMETER :: NOSAMPLES = 1001
  REAL(LATTEPREC), ALLOCATABLE :: SCLGSP(:,:)
  REAL(LATTEPREC) :: MAGR
  REAL(LATTEPREC) :: RMINUSR1, RMINUSR12, RMINUSR14

  ALLOCATE( SCLGSP(NOSAMPLES, NOINT) )

  DO IGS = 1, NOINT

     DO I = 1, NOSAMPLES

        MAGR = HALF + THREE*FLOAT(I-1)/FLOAT(NOSAMPLES)

        IF (MAGR .LE. GSPR1(IGS)) THEN

           SCLGSP(I,IGS) = ((GSPR0(IGS)/MAGR)**GSPN(IGS)) * & 
                EXP(GSPN(IGS)*(((GSPR0(IGS)/GSPRC(IGS))**GSPNC(IGS)) & 
                - ((MAGR/GSPRC(IGS))**GSPNC(IGS))))

        ELSEIF (MAGR .GT. GSPR1(IGS) .AND. MAGR .LT. GSPRCUT(IGS)) THEN

           RMINUSR1 = MAGR - GSPR1(IGS)
           RMINUSR12 = RMINUSR1*RMINUSR1
           RMINUSR14 = RMINUSR12*RMINUSR12
           
           SCLGSP(I,IGS) = B(1,IGS) + B(2,IGS)*RMINUSR1 + &
                B(3,IGS)*RMINUSR12 + &
                B(4,IGS)*RMINUSR12*RMINUSR1 + B(5,IGS)*RMINUSR14 + &
                B(6,IGS)*RMINUSR14*RMINUSR1

        ELSEIF (MAGR .GE. GSPRCUT(IGS)) THEN

           SCLGSP(I,IGS) = ZERO

        ENDIF

     ENDDO
     
  ENDDO

  OPEN(UNIT=40, STATUS="UNKNOWN", FILE="GSP_scaling.dat")

  DO I = 1, NOSAMPLES

     MAGR = HALF + THREE*FLOAT(I-1)/FLOAT(NOSAMPLES)

     WRITE(40,10) MAGR, (HR0(J)*SCLGSP(I,J), J = 1, NOINT)

  ENDDO
  
  10 FORMAT(F12.6, 50F18.9)

  DEALLOCATE(SCLGSP)

  RETURN
  
END SUBROUTINE PLOTGSP
