!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE PPOTHYBRID

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY
  USE NEBLISTARRAY
  USE VIRIALARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, NEWJ, J, K, PPSEL
  INTEGER :: PBCI, PBCJ, PBCK
  REAL(LATTEPREC) :: JR1, JRCUT, R1, RCUT2
  REAL(LATTEPREC) :: FORCE, DC(3), RIJ(3)
  REAL(LATTEPREC) :: MYR, MYR2, MYR3, MYR4, MAGR2, MAGR
  REAL(LATTEPREC) :: CUBICPHI, JOINPHI, VDWPHI, CUTPHI, TMP
  REAL(LATTEPREC) :: VIRCUBIC(6), VIRJOIN(6), VIRVDW(6), VIRCUT(6)
  REAL(LATTEPREC) :: FCUBIC(3), FJOIN(3), FVDW(3), FCUT(3)

  ! 
  ! In this subroutine we add contributions in a strange way to ensure
  ! numerical accuracy when switching between single and double precision.
  ! If we don't do this, we get errors associated with adding very small
  ! numbers to very large ones, and energies can be off by 0.01% or more.
  !

  !
  ! There are 4 different parts to the pair potential:
  !
  ! 1) Short range repulsion fitting to give bond lengths etc
  ! 2) The joining function from JOINR1 TO JOINRCUT
  ! 3) The vdW-type pair potential from JOINCUT to PPR1
  ! 4) The final cut off tail from PPR1 TO PPRCUT
  !

  CUBICPHI = ZERO
  JOINPHI = ZERO
  VDWPHI = ZERO
  CUTPHI = ZERO

  VIRCUBIC = ZERO
  VIRJOIN = ZERO 
  VIRVDW = ZERO
  VIRCUT = ZERO

  DO I = 1, NATS
     
     FCUBIC = ZERO
     FJOIN = ZERO
     FVDW = ZERO
     FCUT = ZERO

     DO NEWJ = 1, TOTNEBPP(I)
        
        J = NEBPP(I, NEWJ, 1)
        
        PBCI = NEBPP(I, NEWJ, 2)
        PBCJ = NEBPP(I, NEWJ, 3)
        PBCK = NEBPP(I, NEWJ, 4)
        
        DO K = 1, NOPPS
           
           IF ((ATELE(I) .EQ. PPELE1(K) .AND. ATELE(J) .EQ. PPELE2(K)) &
                .OR. (ATELE(J) .EQ. PPELE1(K) .AND. &
                ATELE(I) .EQ. PPELE2(K))) THEN
              
              PPSEL = K
              
              JR1 = JOINR1(PPSEL)
              JRCUT = JOINRCUT(PPSEL)
              R1 = PPR1(PPSEL)
              
              RCUT2 = PPRCUT(PPSEL)*PPRCUT(PPSEL)
              
           ENDIF
           
        ENDDO
        
        RIJ(1) = CR(1,J) + FLOAT(PBCI)*(BOX(2,1) - BOX(1,1)) - CR(1,I)
        RIJ(2) = CR(2,J) + FLOAT(PBCJ)*(BOX(2,2) - BOX(1,2)) - CR(2,I)
        RIJ(3) = CR(3,J) + FLOAT(PBCK)*(BOX(2,3) - BOX(1,3)) - CR(3,I)
        
        MAGR2 = RIJ(1)*RIJ(1) + RIJ(2)*RIJ(2) + RIJ(3)*RIJ(3)
        
        IF (MAGR2 .LE. RCUT2) THEN
           
           MAGR = SQRT(MAGR2)
           
           ! Direction cosines
           
           DO K = 1, 3
              
              DC(K) = RIJ(K)/MAGR
              
           ENDDO
           
           IF (MAGR .LT. JR1) THEN
              
              FORCE = ZERO
              
              DO K = 1, PPK(PPSEL)
                 
                 IF (MAGR .LT. PPRK(K, PPSEL)) THEN
                    
                    MYR = PPRK(K, PPSEL) - MAGR
                    
                    CUBICPHI = CUBICPHI + PPAK(K,PPSEL)*MYR*MYR*MYR
                    
                    FORCE = FORCE - THREE*PPAK(K,PPSEL)*MYR*MYR
                    
                 ENDIF
                 
              ENDDO

              DO K = 1, 3
                 FCUBIC(K) = FCUBIC(K) + DC(K)*FORCE
              ENDDO

              VIRCUBIC(1) = VIRCUBIC(1) + RIJ(1)*DC(1)*FORCE
              VIRCUBIC(2) = VIRCUBIC(2) + RIJ(2)*DC(2)*FORCE
              VIRCUBIC(3) = VIRCUBIC(3) + RIJ(3)*DC(3)*FORCE
              VIRCUBIC(4) = VIRCUBIC(4) + RIJ(1)*DC(2)*FORCE
              VIRCUBIC(5) = VIRCUBIC(5) + RIJ(2)*DC(3)*FORCE
              VIRCUBIC(6) = VIRCUBIC(6) + RIJ(3)*DC(1)*FORCE
              
           ELSEIF (MAGR .GE. JR1 .AND. MAGR .LT. JRCUT) THEN
              
              MYR = MAGR - JR1
              MYR2 = MYR*MYR
              MYR3 = MYR2*MYR
              MYR4 = MYR3*MYR
              
              JOINPHI =  JOINPHI + JOINB(1,PPSEL) + JOINB(2,PPSEL)*MYR + &
                   JOINB(3,PPSEL)*MYR2 + JOINB(4,PPSEL)*MYR3 + &
                   JOINB(5,PPSEL)*MYR4 + JOINB(6,PPSEL)*MYR4*MYR
              
              FORCE = JOINB(2,PPSEL) + TWO*JOINB(3,PPSEL)*MYR + &
                   THREE*JOINB(4,PPSEL)*MYR2 + FOUR*JOINB(5,PPSEL)*MYR3 + &
                   FIVE*JOINB(6,PPSEL)*MYR4

              DO K = 1, 3
                 FJOIN(K) = FJOIN(K) + DC(K)*FORCE
              ENDDO

              VIRJOIN(1) = VIRJOIN(1) + RIJ(1)*DC(1)*FORCE
              VIRJOIN(2) = VIRJOIN(2) + RIJ(2)*DC(2)*FORCE
              VIRJOIN(3) = VIRJOIN(3) + RIJ(3)*DC(3)*FORCE
              VIRJOIN(4) = VIRJOIN(4) + RIJ(1)*DC(2)*FORCE
              VIRJOIN(5) = VIRJOIN(5) + RIJ(2)*DC(3)*FORCE
              VIRJOIN(6) = VIRJOIN(6) + RIJ(3)*DC(1)*FORCE
              
           ELSEIF (MAGR .GE. JRCUT .AND. MAGR .LT. R1) THEN
              
              TMP = MINUSONE*VDWC(PPSEL)/(MAGR2*MAGR2*MAGR2)
              
              VDWPHI = VDWPHI + TMP
              
              FORCE = MINUSONE*SIX*TMP/MAGR

              DO K = 1, 3
                 FVDW(K) = FVDW(K) + DC(K)*FORCE
              ENDDO

              VIRVDW(1) = VIRVDW(1) + RIJ(1)*DC(1)*FORCE
              VIRVDW(2) = VIRVDW(2) + RIJ(2)*DC(2)*FORCE
              VIRVDW(3) = VIRVDW(3) + RIJ(3)*DC(3)*FORCE
              VIRVDW(4) = VIRVDW(4) + RIJ(1)*DC(2)*FORCE
              VIRVDW(5) = VIRVDW(5) + RIJ(2)*DC(3)*FORCE
              VIRVDW(6) = VIRVDW(6) + RIJ(3)*DC(1)*FORCE

           ELSEIF (MAGR .GE. R1) THEN
              
              MYR = MAGR - R1
              MYR2 = MYR*MYR
              MYR3 = MYR2*MYR
              MYR4 = MYR3*MYR
              
              CUTPHI = CUTPHI + PPCUTB(1,PPSEL) + PPCUTB(2,PPSEL)*MYR + &
                   PPCUTB(3,PPSEL)*MYR2 + PPCUTB(4,PPSEL)*MYR3 + &
                   PPCUTB(5,PPSEL)*MYR4 + PPCUTB(6,PPSEL)*MYR4*MYR
              
              FORCE = PPCUTB(2,PPSEL) + TWO*PPCUTB(3,PPSEL)*MYR + &
                   THREE*PPCUTB(4,PPSEL)*MYR2 + &
                   FOUR*PPCUTB(5,PPSEL)*MYR3 + &
                   FIVE*PPCUTB(6,PPSEL)*MYR4

              DO K = 1, 3
                 FCUT(K) = FCUT(K) + DC(K)*FORCE
              ENDDO

              VIRCUT(1) = VIRCUT(1) + RIJ(1)*DC(1)*FORCE
              VIRCUT(2) = VIRCUT(2) + RIJ(2)*DC(2)*FORCE
              VIRCUT(3) = VIRCUT(3) + RIJ(3)*DC(3)*FORCE
              VIRCUT(4) = VIRCUT(4) + RIJ(1)*DC(2)*FORCE
              VIRCUT(5) = VIRCUT(5) + RIJ(2)*DC(3)*FORCE
              VIRCUT(6) = VIRCUT(6) + RIJ(3)*DC(1)*FORCE 
              
           ENDIF
           
        ENDIF
        
     ENDDO

     DO K = 1, 3
        FPP(K,I) = FCUBIC(K) + FJOIN(K) + FVDW(K) + FCUT(K)
     ENDDO

  ENDDO

  EREP = HALF*(CUBICPHI + JOINPHI + VDWPHI + CUTPHI)

  DO K = 1, 6
     VIRPAIR(K) = HALF*(VIRCUBIC(K) + VIRJOIN(K) + VIRVDW(K) + VIRCUT(K))
  ENDDO

  RETURN
  
END SUBROUTINE PPOTHYBRID

