!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE READCONTROLS

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY  
  USE NEBLISTARRAY
  USE COULOMBARRAY
  USE FERMICOMMON
  USE SPARSEIND
  
  IMPLICIT NONE

  CHARACTER(LEN=20) :: HD

  OPEN(UNIT=13, STATUS="OLD", FILE="TBparam/control.in")

  !
  ! CONTROL determines how the density matrix is going to be 
  ! calculated: 1 = diagonalization, 2 = SP2 purification,
  ! 3 = recursive expansion of the Fermi operator
  !

  READ(13,*) HD, CONTROL 

  !
  ! Read the order of the recursion in the expansion of the Fermi 
  ! operator, M.
  !

  READ(13,*) HD, FERMIM

  ! If we're using the expansion of the Fermi operator, we can
  ! use a LAPACK routine or Niklasson's conjugate gradient method to
  ! solve AX = B. CGORLIB: 0 = LAPACK, 1 = conjugate gradient
  ! CGTOL = the user-supplied tolerance for the CG solution of AX = B

  READ(13,*) HD, CGORLIB, HD, CGTOL

  CGTOL2 = CGTOL*CGTOL

  ! Electronic temperature, in eV

  READ(13,*) HD, KBT

  !
  ! Read the number of recursions for the truncated, finite
  ! temperature SP2 algorithm
  !

  READ(13,*) HD, NORECS

  !
  ! What kind of entropy are we going to use in a finite Te calculation
  !
  ! ENTROPYKIND = 0 : none
  ! ENTROPYKIND = 1 : exact for Fermi-Dirac occupation
  ! ENTROPYKIND = 2 : Different form of exact expression that may be useful
  ! when using CONTROL = 5
  ! ENTROPYKIND = 3 : 4th order expansion of exact form (no diag)
  ! ENTROPYKIND = 4 : 8th order expansion of exact form (no diag)
  !

  READ(13,*) HD, ENTROPYKIND

  !
  ! Are we doing a spin-polarized calculation?
  ! SPINON = 1 = yes
  ! SPINON = 0 = no

  READ(13,*) HD, SPINON, HD, SPINTOL

  !
  ! Controls for electrostatics:
  !
  ! ELECTRO: 0 = LCN is applied, 1 = charge dependent TB on
  ! ELECMETH: 0 = Ewald  summation, 1 = All real space 
  ! ELEC_ETOL: Tolerance on energy when determining charges (not implemented)
  ! ELEC_QTOL: Tolerance on charges during self-consistent calc
  !

  READ(13,*) HD, ELECTRO, HD, ELECMETH, HD, ELEC_ETOL, HD, ELEC_QTOL

  ! 
  ! COULACC: Accuracy for the Ewald method (1.0e-4 works)
  ! COULCUT: If we're using the Ewald method, this is the cut-off for the
  ! real space part. If we're doing it all in real space, this is the radial
  ! cut-off for the sum.
  ! COULR1: If we're doing it in real space, the cut-off tail on 1/R is
  ! applied here at terminated at COULCUT.
  !

  READ(13,*) HD, COULACC, HD, COULCUT, HD, COULR1

  !
  ! MAXSCF:  Maximum number of SCF cycles
  !
  
  READ(13,*) HD, MAXSCF

  !
  ! BREAKTOL: Tolerance for breaking SP2 loops
  ! MINSP2ITER: Minimum number of iterations during SP2 purification
  !

  READ(13,*) HD, BREAKTOL, HD, MINSP2ITER

  !
  ! FULLQCONV: 0 = We'll run QITER SCF cycles during MD, = 1, we'll run 
  ! SCF cycles until we've reached ELEC_QTOL. Only important for MD
  ! QITER: Number of SCF cycles we're going to run at each MD time step
  !

  READ(13,*) HD, FULLQCONV, HD, QITER

  !
  ! QMIX AND SPINMIX are the coefficients for the linear mixing of
  ! new and old charge and spin densities, respectively, during SCF cycles
  !

  READ(13,*) HD, QMIX, HD, SPINMIX

  !
  ! ORDERNMOL: Turn on molecule-ID-based density matrix blocking
  !
  
  READ(13,*) HD, ORDERNMOL

  !
  ! SPARSEON: 0 = all dense matrix stuff, 1 = use Cawkwell's quasi-sparse
  ! matrix stuff during SP2 and Fermi method
  !

  READ(13,*) HD, SPARSEON

  ! 
  ! LCNON: 0 = during charge neutral MD simulations we'll run LCNITER SCF
  ! cycles at each time step, 1 = we'll run SCF cycles until CHTOL is reached
  ! LCNITER: Number of SCF cycles to achieve LCN at each MD time step
  ! CHTOL: Tolerance on atomic charges (Mulliken) before LCN is declared
  !

  READ(13,*) HD, LCNON, HD, LCNITER, HD, CHTOL

  !
  ! Read the SKIN for the neighbor list (Angstrom)
  !

  READ(13,*) HD, SKIN  

  !
  ! RELAXME: 0 = Don't run steepest descent geometry optimization, 1 = run
  ! a steepest descent geometry optimization
  ! MXRLX: Maximum number of steps in the geometry optimization
  ! RLXFTOT: Run optimization until all forces are less than RLXFTOL
  !

  READ(13,*) HD, RELAXME, HD, MXRLX, HD, RLXFTOL

  !
  ! MDON: 0 = Molecular dynamics off, 1 = Molecular dynamics on
  ! (MD is controlled using the file MDcontroller)
  !

  READ(13,*) HD, MDON

  !
  ! BOXON: 0 = full periodic boundary conditions, 1 = reflecting box (may
  ! be broken)
  !

  READ(13,*) HD, BOXON

  !
  ! MD specific flags
  !

  RESTART = 0
  XBOON = 0
  XBODISON = 0
  XBODISORDER = 0

  IF (MDON .EQ. 1) THEN

     !
     ! RESTART: 0 = start from scratch, 1 = read the coordinates and 
     ! velocities from the restart file bl/restart.dat
     !

     READ(13,*) HD, RESTART

     !
     ! XBOON: 0 = Niklasson's extended Lagrangian Born-Oppenheimer MD off,
     ! 1 = on.
     !

     READ(13,*) HD, XBOON
     IF (XBOON .EQ. 1) THEN

        !
        ! XBODISON: We have the option of turning on damping for the XBO
        ! to remedy the accumulation of noise. 0 = off, 1 = on.
        !

        READ(13,*) HD, XBODISON

        ! 
        ! XBODISORDER: = Order of the damping function (1 - 9)
        !

        READ(13,*) HD, XBODISORDER
     ENDIF
  ENDIF

  CLOSE(13) 

  !
  ! Summarize the calculation we're doing here
  !

!  OPEN(UNIT=99, STATUS="UNKNOWN", FILE="my_last_LATTE_calc")

!  IF (CONTROL .EQ. 1) THEN
!     WRITE(99,*) "Diagonization used to calculate bond order"
!  ELSEIF (CONTROL .EQ. 2 .AND. SPARSEON .EQ. 0) THEN
!     WRITE(99,*) "Dense matrix SP2 used to calculate bond order"
!  ELSEIF (CONTROL .EQ. 2 .AND. SPARSEON .EQ. 1) THEN
!     WRITE(99,*) "Quasi-sparse matrix SP2 used to calculated bond order"
!  ELSEIF (CONTROL .EQ. 3) THEN
!     WRITE(99,*) "Recursive expansion of the Fermi operator"
!     IF (CGORLIB .EQ. 0) THEN
!        WRITE(99,*) "Dense matrix: using LAPACK routine to solve AX=B"
!     ENDIF
!     IF (CGORLIB .EQ. 1 .AND. SPARSEON .EQ. 0) THEN
!        WRITE(99,*) "Dense matrix conjugate gradient scheme to solve AX=B"
!     ELSEIF (CGORLIB .EQ. 1 .AND. SPARSEON .EQ. 1) THEN
!        WRITE(99,*) "Sparse matrix conjugate gradient scheme to solve AX=B"
!     ENDIF
!  ENDIF


  RETURN

END SUBROUTINE READCONTROLS
