!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE READCR()

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PBCARRAY
  USE NEBLISTARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, MYINDEX
  REAL(LATTEPREC) :: LN(6)
  CHARACTER(LEN=20) :: HEADER

  OPEN(UNIT=12, STATUS="OLD", FILE="bl/inputblock.dat")

  READ(12,*) HEADER, NATS
  
  ALLOCATE(CR(3,NATS), ATELE(NATS), F(3,NATS), FPP(3,NATS), FTOT(3,NATS))
  ALLOCATE(PBCUNWRAP(3,NATS))

  PBCUNWRAP = 0

  READ(12,*) ALAT
  READ(12,*) LN(1), LN(2), LN(3), LN(4), LN(5), LN(6)

  MYINDEX = 0
  DO I = 1, 3
     DO J = 1, 2
        MYINDEX = MYINDEX + 1
        BOX(J,I) = LN(MYINDEX)*ALAT
     ENDDO
  ENDDO

  READ(12,*) (CR(1,I), CR(2,I), CR(3,I), ATELE(I), I = 1, NATS)

  CLOSE(12)

  CR = ALAT*CR

!  DO I = 1, NATS
!     DO J = 1, 3
!        CR(J,I) = CR(J,I) * ALAT
!     ENDDO
!  ENDDO

  IF (ORDERNMOL .EQ. 1) THEN
     ALLOCATE(MOLID(NATS))
  ENDIF

  RETURN

END SUBROUTINE READCR
