!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE READTB()

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE GSPARRAY
  USE MDARRAY
  USE SPINARRAY

  IMPLICIT NONE

  INTEGER :: I
  CHARACTER(LEN=20) :: HD

  OPEN(UNIT=22,STATUS="OLD", FILE="TBparam/electrons.dat")

  READ(22,*) HD, NOELEM

  ALLOCATE(ELE(NOELEM), BASIS(NOELEM), ATOCC(NOELEM), HES(NOELEM), &
       HEP(NOELEM), MASS(NOELEM), HUBBARDU(NOELEM), WSS(NOELEM), &
       WSP(NOELEM), WPP(NOELEM))

  READ(22,*) HD, HD, HD, HD, HD, HD, HD, HD, HD, HD

  READ(22,*) (ELE(I), BASIS(I), ATOCC(I), HES(I), HEP(I), MASS(I), &
       HUBBARDU(I), WSS(I), WSP(I), WPP(I), I = 1, NOELEM)

  CLOSE(22)

  OPEN(UNIT=11,STATUS="OLD", FILE="TBparam/bondints.dat")

  READ(11,*) HD, NOINT

  ALLOCATE(ELE1(NOINT), ELE2(NOINT), HR0(NOINT), BTYPE(NOINT),&
       GSPR0(NOINT), GSPRC(NOINT), GSPR1(NOINT), &
       GSPRCUT(NOINT), GSPN(NOINT), GSPNC(NOINT), B(6,NOINT))
  
  READ(11,*) HD, HD, HD, HD, HD, HD, HD, HD, HD, HD
  
  READ(11,*) (ELE1(I), ELE2(I), BTYPE(I), HR0(I), &
       GSPR0(I), GSPRC(I), GSPN(I), GSPNC(I), GSPR1(I), &
       GSPRCUT(I), I = 1, NOINT)

  CLOSE(11)

  CALL TAILCOEF
  
  RETURN
  
END SUBROUTINE READTB
