!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE TAILCOEF

  USE CONSTANTS_MOD
  USE GSPARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I
  REAL(LATTEPREC) :: DELTA, R0, R1, N, RC, NC, RCUT
  REAL(LATTEPREC) :: SCLGSP_R1
  REAL(LATTEPREC) :: DELTA2, DELTA3, DELTA4

  DO I = 1, NOINT
     
     R0 = GSPR0(I)
     R1 = GSPR1(I)
     RC = GSPRC(I)
     N = GSPN(I)
     NC = GSPNC(I)
     RCUT = GSPRCUT(I)

     DELTA = RCUT - R1

     ! Now we're using a 6th order polynomial: fitted to value, first, 
     ! and second derivatives at R1 and R_cut

     SCLGSP_R1 = ((R0/R1)**N) * EXP(N*(((R0/RC)**NC) - ((R1/RC)**NC)))

     B(1,I) = SCLGSP_R1

     B(2,I) = MINUSONE*(N/R1)*(NC*((R1/RC)**NC) + ONE) * SCLGSP_R1

     B(3,I) = HALF*SCLGSP_R1*((((N/R1)*(NC*((R1/RC)**NC) + ONE)* &
          (N/R1)*(NC*((R1/RC)**NC) + ONE))) + (N/(R1*R1))* &
          ((NC*((R1/RC)**NC) + ONE) - (N*(NC/R1)*(NC/R1)*((R1/RC)**NC))))

     DELTA2 = DELTA*DELTA
     DELTA3 = DELTA2*DELTA
     DELTA4 = DELTA3*DELTA

     B(4,I) = (MINUSONE/DELTA3)*(THREE*B(3,I)*DELTA2 + &
          SIX*B(2,I)*DELTA + TEN*B(1,I))
     
     B(5,I) = (ONE/DELTA4)*(THREE*B(3,I)*DELTA2 + &
          EIGHT*B(2,I)*DELTA + FIFTEEN*B(1,I))

     B(6,I) = (MINUSONE/(TEN*DELTA3)) * &
          (SIX*B(5,I)*DELTA2 + THREE*B(4,I)*DELTA + B(3,I))
     
  ENDDO
     
  RETURN

END SUBROUTINE TAILCOEF
