!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE TBMD

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE PPOTARRAY
  USE MDARRAY
  USE NEBLISTARRAY
  USE SPARSEIND
  USE COULOMBARRAY
  USE SPINARRAY
  USE VIRIALARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I
  INTEGER :: ITER
  INTEGER :: CURRITER, TOTSCF
  REAL(LATTEPREC) :: MYTEMP, THETIME
  REAL(LATTEPREC), PARAMETER :: CONV = 2.0D0*1.60219D0/(3.0D0*1.38062D-4)

  !
  ! Read MDcontroller to determine what kind of MD simulation to do
  !

  CALL READMDCONTROLLER

  !
  ! Allocate stuff for building the neighbor lists, then build them
  !

  CALL ALLOCATENEBARRAYS

  CALL NEBLISTS(0)

  !
  ! Allocate things depending on which method we're using
  ! to get the bond-order
  !
  
  IF (CONTROL .EQ. 1) THEN
     CALL ALLOCATEDIAG
  ELSEIF (CONTROL .EQ. 2 .OR. CONTROL .EQ. 4 .OR. CONTROL .EQ. 5) THEN
     CALL ALLOCATEPURE
  ELSEIF (CONTROL .EQ. 3) THEN
     CALL FERMIALLOCATE
  ENDIF

  IF (SPARSEON .EQ. 1) THEN
     CALL ALLOCATENONZERO
  ENDIF

  IF (RESTART .EQ. 0) THEN

     ALLOCATE (V(3,NATS))
     
     !
     ! Initialize velocities if TOINITTEMP = 1
     !
     
     IF (TOINITTEMP .EQ. 1) THEN
        CALL INITIALV
     ELSE
        WRITE(6,*) "Caution: you haven't initialized velocities"
     ENDIF

  ENDIF

  IF (VARDT .EQ. 1) THEN
     TZERO = TEMP
     DTZERO = DT
  ENDIF

  !
  ! If we're going to run with the Hugoniostat, some things need
  ! to be initialized
  !

  IF (SHOCKON .EQ. 1) THEN
     CALL INITSHOCKCOMP
  ENDIF
  
  !
  ! Get forces - we need these at this point only if we're running
  ! NVE MD with the velocity verlet algorithm
  !

  CURRITER = 1
  
  IF (RESTART .EQ. 0) THEN

     CALL GETMDF(0,1)

  ELSEIF (RESTART .EQ. 1) THEN
     
     !
     ! If we've read from a restart file then we don't need to run
     ! qconsistency to full self-consistency at the first time step of
     ! the new run - we're already there...
     !

     ! Yes we do until this is fixed

     CALL GETMDF(0,1)

  ENDIF

  IF (RESTART .EQ. 0) THEN
     ITER = 0
  ELSE
     ITER = CONTITER
  ENDIF

  IF (NVTON .EQ. 1) THEN
     
     ALLOCATE(THIST(AVEPER))

     DO I = 1, AVEPER
        THIST(I) = TEMP
     ENDDO

  ENDIF

  CALL WRTCFGS(ITER)

  TOTSCF = 0

  WRITE(6,17) "#","Time (ps)", "Free energy (eV)", "T (K)", "Pressure (GPa)"

17 FORMAT(A1, 2X, A10, 9X, A16, 2X, A5, 3X, A14) 

  DO WHILE (ITER .LE. MAXITER)

     TOTSCF = TOTSCF + SCFS_II

     CURRITER = CURRITER + 1

     ITER = ITER + 1

     IF (SHOCKON .EQ. 1 .AND. ITER .GE. SHOCKSTART .AND. &
          ITER .LT. SHOCKSTOP) THEN
        
        CALL SHOCKCOMP

        !
        ! Since we're chaning the dimensions of the box, we
        ! should probably also adjust the reciprocal lattice vectors
        ! used in the Ewald sum. There's no harm in doing this
        ! every time step while the box size is changing
        !
        ! We may as well reinitialize the Coulomb stuff since
        ! it also optimizes the real-space cut-off based on the volume
        ! of the cell
        !

        CALL INITCOULOMB

     ENDIF

     IF (NVTON .EQ. 0 .OR. CURRITER .GT. THERMRUN) THEN

        CALL VELVERLET(CURRITER)

     ELSEIF (NVTON .EQ. 1 .AND. CURRITER .LE. THERMRUN) THEN
        
        ! Velocity rescaling thermostat

        !
        ! To smooth things out, let's average the
        ! temperature over the previous AVEPER time steps
        !

        CALL AVETEMP

        IF (MOD(ITER, THERMPER) .NE. 0) THEN

           ! No velocity rescaling every timestep

           CALL VELVERLET(CURRITER)

        ELSEIF (MOD(ITER, THERMPER) .EQ. 0) THEN

!           CALL GETMDF(1, 2)
           
           CALL NVTRESCALE

        ENDIF

     ENDIF     

     IF (MOD(ITER,WRTFREQ) .EQ. 0) THEN

        CALL TOTENG

        CALL PPOTHYBRID

        CALL GETKE

        ENTE = ZERO
        IF (CONTROL .NE. 2 .AND. KBT .GT. 0.000001 ) THEN

           CALL ENTROPY

        ENDIF

        ECOUL = ZERO
        IF (ELECTRO .EQ. 1) THEN
           
           CALL GETCOULE

        ENDIF

        ESPIN = ZERO
        IF (SPINON .EQ. 1) THEN
           
           CALL GETSPINE

        ENDIF

        CALL GETPRESSURE

        TOTE = TRRHOH + EREP + KEE - ENTE - ECOUL + ESPIN - ESPIN_ZERO

        MYTEMP = CONV*KEE/FLOAT(NATS)

        THETIME = FLOAT(ITER)*DT/THOUSAND

        WRITE(6,16) THETIME, TOTE, MYTEMP, PRESSURE

16      FORMAT(F12.5, F20.8, 1X, F9.1, 1X, F12.1)

     ENDIF
     
     IF (MOD(ITER,DUMPFREQ) .EQ. 0) THEN

        CALL WRTCFGS(ITER)

     ENDIF

     IF (MOD(ITER, RSFREQ) .EQ. 0) THEN

        CALL WRTRESTART(ITER)

     ENDIF

     IF (MOD(ITER, UDNEIGH) .EQ. 0) THEN
        CALL NEBLISTS(1)
     ENDIF     

  ENDDO

  DEALLOCATE(V)

  IF (CONTROL .EQ. 1) THEN
     CALL DEALLOCATEDIAG
  ELSEIF (CONTROL .EQ. 2 .OR. CONTROL .EQ. 4 .OR. CONTROL .EQ. 5) THEN
     CALL DEALLOCATEPURE
  ELSEIF (CONTROL .EQ. 3) THEN
     CALL FERMIDEALLOCATE
  ENDIF

  IF (SPARSEON .EQ. 1) THEN
     CALL DEALLOCATENONZERO
  ENDIF

  IF (NVTON .EQ. 1) THEN
     
    DEALLOCATE(THIST)

  ENDIF

  RETURN

END SUBROUTINE TBMD
