!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE WRTRESTART(ITER)

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE MDARRAY
  USE SPINARRAY
  USE PBCARRAY

  IMPLICIT NONE

  INTEGER :: I, ITER
  CHARACTER(LEN=100) :: FLNM

  IF (MDON .EQ. 1) THEN

     IF (ITER .LT. 10) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I1,".dat")') ITER
     ELSEIF (ITER .GE. 10 .AND. ITER .LT. 100) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I2,".dat")') ITER
     ELSEIF (ITER .GE. 100 .AND. ITER .LT. 1000) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I3,".dat")') ITER
     ELSEIF (ITER .GE. 1000 .AND. ITER .LT. 10000) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I4,".dat")') ITER
     ELSEIF (ITER .GE. 10000 .AND. ITER .LT. 100000) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I5,".dat")') ITER
     ELSEIF (ITER .GE. 100000 .AND. ITER .LT. 1000000) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I6,".dat")') ITER
     ELSEIF (ITER .GE. 1000000 .AND. ITER .LT. 10000000) THEN
        WRITE(FLNM,'("Restarts/restartMD.", I7,".dat")') ITER
     ENDIF

     OPEN (UNIT = 21, STATUS="UNKNOWN", FILE=FLNM)

  ELSEIF (RELAXME .EQ. 1) THEN

     OPEN (UNIT = 21, STATUS="UNKNOWN", FILE="restartREL.dat")

  ENDIF

  WRITE(21,16) "Iter= ", ITER
  WRITE(21,10) "Nats= ", NATS
  WRITE(21,11) "1.0"
  WRITE(21,12) BOX(1,1), BOX(2,1), BOX(1,2), BOX(2,2), &
       BOX(1,3), BOX(2,3)

  DO I = 1, NATS
     WRITE(21,14) CR(1,I), CR(2,I), CR(3,I), ATELE(I)
  ENDDO

  WRITE(21,17) CHEMPOT

  IF (SPINON .EQ. 0) THEN

     WRITE(21,18) HDIM
     DO I = 1, HDIM
        WRITE(21,17) BO(I,I)
     ENDDO

  ELSEIF (SPINON .EQ. 1) THEN

     WRITE(21,18) HDIM
     DO I = 1, HDIM
        WRITE(21,19) RHOUP(I,I), RHODOWN(I,I)
     ENDDO

  ENDIF

  IF (MDON .EQ. 1) THEN
     DO I = 1, NATS
        WRITE(21,15) V(1,I), V(2,I), V(3,I)
     ENDDO
  ENDIF


10 FORMAT(A6,1X,I7)
11 FORMAT(A3)
12 FORMAT(6(E24.16,1X))
!13 FORMAT(3(E24.16,1X),A2,1X,3(I4,1X))
14 FORMAT(3(E24.16,1X),A2)
15 FORMAT(3(E24.16,1X))
16 FORMAT(A6, 1X, I10)
17 FORMAT(E24.16)
18 FORMAT(I12)
19 FORMAT(2E24.16)

  CLOSE(21)

  RETURN

END SUBROUTINE WRTRESTART
