/* Copyright (C) 2004 W.P. van Paassen - peter@paassen.tmfweb.nl

   This program is a test program for libmd5model
   
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */

#include "libmd5model.h"
#include <stdlib.h>
#include <stdio.h>

int main(int argc, char** argv)
{
	int ret, i,j;
	MD5MESH_HEADER* mesh_header;
	
	ret = MD5_parse(argv[1]);

	if (ret == MD5_PARSED_FAIL)
		return MD5_PARSED_FAIL;

	if (ret == MD5_PARSED_MESH)
	{
		mesh_header = MD5Mesh_get_header();

		printf("**************************************\n");
		printf("MD5 HEADER \n");
		printf("VERSION: %i\n",mesh_header->version);
		printf("COMMANDLINE: %s\n",mesh_header->commandline);
		printf("# JOINTS: %i\n",mesh_header->num_joints);
		printf("# MESHES: %i\n",mesh_header->num_meshes);
		printf("**************************************\n");
	
		printf("JOINTS \n");
		for (i = 0; i < mesh_header->num_joints; ++i)
		{
			MD5MESH_JOINT* joint = MD5Mesh_get_joint(i);
			printf("**************************************\n");
			printf("JOINT NAME: %s\n", joint->name);
			if (joint->parent != (MD5MESH_JOINT*)NULL)
				printf("PARENT JOINT NAME: %s\n", joint->parent->name);
			printf("JOINT POSITION: x: %.10f y: %.10f z: %.10f\n", joint->position.x, joint->position.y, joint->position.z);
			printf("JOINT ORIENTATION: x: %.10f y: %.10f z: %.10f w: %.10f\n", joint->orientation.x, joint->orientation.y, joint->orientation.z, joint->orientation.w);
		}

		printf("MESHES \n");
		for (i = 0; i < mesh_header->num_meshes; ++i)
		{
			MD5_MESH* mesh = MD5Mesh_get_mesh(i);
			printf("**************************************\n");
			printf("MESH %i SHADER NAME: %s\n", i, mesh->shader);
			printf("MESH %i # vertices: %i\n", i, mesh->num_verts);
			for (j=0; j < mesh->num_verts; ++j)
			{
				MD5_VERTEX* vertex = (MD5_VERTEX*)MD5Mesh_get_vertex(i, j);
				printf("\tMESH %i VERTEX %i\n", i, j);
				printf("\tMESH %i VERTEX %i TEXTURE_U %.10f\n", i, j, vertex->texture_u);
				printf("\tMESH %i VERTEX %i TEXTURE_V %.10f\n", i, j, vertex->texture_v);
				if (vertex->weight != (MD5_WEIGHT*)NULL)
					printf("\tMESH %i VERTEX %i START_WEIGHT ADDRESS %X\n", i, j, (unsigned int)vertex->weight);
				printf("\tMESH %i VERTEX %i # WEIGHTS %i\n", i, j, vertex->num_weights);
			}

			printf("MESH %i # triangles: %i\n", i, mesh->num_tris);
			for (j=0; j < mesh->num_tris; ++j)
			{
				MD5_TRIANGLE* triangle = (MD5_TRIANGLE*)MD5Mesh_get_triangle(i, j);
				printf("\tMESH %i TRIANGLE %i\n", i, j);
				if (triangle->vertex1 != (MD5_VERTEX*)NULL)
					printf("\tMESH %i TRIANGLE %i VERTEX ADDRESS %X\n", i, j, (unsigned int)triangle->vertex1);
				if (triangle->vertex2 != (MD5_VERTEX*)NULL)
					printf("\tMESH %i TRIANGLE %i VERTEX ADDRESS %X\n", i, j, (unsigned int)triangle->vertex2);
				if (triangle->vertex3 != (MD5_VERTEX*)NULL)
					printf("\tMESH %i TRIANGLE %i VERTEX ADDRESS %X\n", i, j, (unsigned int)triangle->vertex3);
			}

			printf("MESH %i # weights: %i\n", i, mesh->num_weights);
			for (j=0; j < mesh->num_weights; ++j)
			{
				MD5_WEIGHT* weight = (MD5_WEIGHT*)MD5Mesh_get_weight(i, j);
				printf("\tMESH %i WEIGHT %i\n", i, j);
				if (weight->joint != (MD5MESH_JOINT*)NULL)
					printf("\tMESH %i WEIGHT %i JOINT ADDRESS %X\n", i, j, (unsigned int)weight->joint);
				printf("\tMESH %i WEIGHT %i VALUE %.10f\n",i,j,weight->weight);
				printf("\tMESH %i WEIGHT %i X_OFFSET %.10f\n",i,j,weight->offset_x);
				printf("\tMESH %i WEIGHT %i Y_OFFSET %.10f\n",i,j,weight->offset_y);
				printf("\tMESH %i WEIGHT %i Z_OFFSET %.10f\n",i,j,weight->offset_z);
			}
		}
	}
	return 0;
}
