# -*- rpm-spec -*-

## rpmbuild options
# These 2 lines are here because we can build the RPM for flexisip, in which
# case we prefix the entire installation so that we don't break compatibility
# with the user's libs.
# To compile with bc prefix, use rpmbuild -ba --with bc [SPEC]
%define                 pkg_name        %{?_with_bc:bc-belle-sip}%{!?_with_bc:belle-sip}
%{?_with_bc: %define    _prefix         /opt/belledonne-communications}
%define                 srtp            %{?_without_srtp:0}%{?!_without_srtp:1}

# re-define some directories for older RPMBuild versions which don't. This messes up the doc/ dir
# taken from https://fedoraproject.org/wiki/Packaging:RPMMacros?rd=Packaging/RPMMacros
%define _datarootdir       %{_prefix}/share
%define _datadir           %{_datarootdir}
%define _docdir            %{_datadir}/doc


Name:           %{pkg_name}
Version:        1.4.2
Release:        %(version=`git describe --tags --abbrev=40 | sed -rn 's/^.*-([0-9]+)-g[a-z0-9]{40}$/\1/p'` && if test -z "$version" ; then echo 0 ; else echo $version ; fi)%{?dist}
Summary:        Linphone sip stack

Group:          Applications/Communications
License:        GPL
URL:            http://www.belle-sip.org
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Source0: 	%{name}-%{version}.tar.gz
%description
Belle-sip is an object oriented SIP stack, written in C, used by Linphone.


BuildRequires: antlr3-tool antlr3-C-devel

%package devel
Summary:       Development libraries for belle-sip
Group:         Development/Libraries
Requires:      %{name} = %{version}-%{release}

%description    devel
Libraries and headers required to develop software with belle-sip

%prep
%setup -q

%build
%configure \
	--disable-tests --enable-static --docdir=%{_docdir}
%__make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root)
%{_includedir}/belle-sip
%{_libdir}/libbellesip.a
%{_libdir}/libbellesip.la
%{_libdir}/libbellesip.so
%{_libdir}/pkgconfig/belle-sip.pc

%changelog
* Mon Aug 19 2013 jehan.monnier <jehan.monnier@linphone.org>
- Initial RPM release.
