############################################################################
# Mediastreamer2Config.cmake
# Copyright (C) 2015  Belledonne Communications, Grenoble France
#
############################################################################
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
############################################################################
#
# Config file for the mediastreamer2 package.
# It defines the following variables:
#
#  MEDIASTREAMER2_FOUND - system has mediastreamer2
#  MEDIASTREAMER2_INCLUDE_DIRS - the mediastreamer2 include directory
#  MEDIASTREAMER2_LIBRARIES - The libraries needed to use mediastreamer2
#  MEDIASTREAMER2_CPPFLAGS - The compilation flags needed to use mediastreamer2
#  MEDIASTREAMER2_LDFLAGS - The linking flags needed to use mediastreamer2

include("${CMAKE_CURRENT_LIST_DIR}/Mediastreamer2Targets.cmake")
find_package(ORTP REQUIRED)
if(YES)
	find_package(BZRTP)
endif()

get_filename_component(MEDIASTREAMER2_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)
set(MEDIASTREAMER2_INCLUDE_DIRS "${MEDIASTREAMER2_CMAKE_DIR}/../../../include")
set(MEDIASTREAMER2_LIBRARIES BelledonneCommunications::mediastreamer_base BelledonneCommunications::mediastreamer_voip)
list(APPEND MEDIASTREAMER2_INCLUDE_DIRS ${ORTP_INCLUDE_DIRS})
list(APPEND MEDIASTREAMER2_LIBRARIES ${ORTP_LIBRARIES})
if(BZRTP_FOUND)
	list(APPEND MEDIASTREAMER2_INCLUDE_DIRS ${BZRTP_INCLUDE_DIRS})
	list(APPEND MEDIASTREAMER2_LIBRARIES ${BZRTP_LIBRARIES})
endif()
set(MEDIASTREAMER2_CPPFLAGS ${ORTP_CPPFLAGS})
set(MEDIASTREAMER2_LDFLAGS )
set(MEDIASTREAMER2_FOUND 1)
