;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-map-push-load
  (lambda (relative-path) 
	 (c-lw6tsk-loader-push (lw6-get-game-global "loader") (lw6-get-game-global "map-path") relative-path (lw6-get-game-global "default-param") (lw6-get-game-global "forced-param") (lw6-config-get-number "width") (lw6-config-get-number "height"))))
	 
(define lw6-map-menu-item
  (lambda (entry)
    (let* (
	   (menuitem (lw6-menu-item-template (assoc-ref entry "title")))
	   (relative-path (assoc-ref entry "relative-path"))
	  )
      (if (assoc-ref entry "has-subdirs")
	  (begin
	    (assoc-set! menuitem "on-valid" (lambda () (lw6-replace-menu (lw6-map-menu relative-path))))
	    )
	  (begin
	    (assoc-set! menuitem "on-select" (lambda () (begin (lw6-game-preview) (lw6-map-push-load relative-path))))
	    (assoc-set! menuitem "on-valid" (lambda () (begin (lw6-game-idle) (lw6-config-set-string! "chosen-map" relative-path))))
	    )
	  ))))

(define lw6-map-menu-item-appender
  (lambda (menu)
    (lambda (entry)
      (lw6-append-menuitem! menu (lw6-map-menu-item entry)))))

(define lw6-map-menu-cancel
  (lambda (relative-path)
    (if (or (equal? relative-path "") (equal? relative-path "."))
	(lw6-pop-menu)
	(display "replace..."))))

(define lw6-map-menu-canceller
  (lambda (relative-path)
    (lambda ()
      (lw6-map-menu-cancel relative-path))))

(define lw6-map-menu
  (lambda (relative-path)
    (let* (
	   (menu (lw6-menu-template (_ "Choose map")))
	   (map-path (c-lw6cfg-unified-get-map-path))
	   (map-parent-path (c-lw6sys-path-parent relative-path))
	   (entries (c-lw6ldr-get-entries map-path map-parent-path))
	  )
      (begin
	(map (lw6-map-menu-item-appender menu) entries)
	(assoc-set! menu "on-cancel" (lw6-map-menu-canceller map-parent-path))
	(assoc-set! menu "on-push" (lambda () (lw6-set-game-global! "display-fun" lw6-display-map)))
	menu
	))))
