/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gfx.h"

static void
_warning (const char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("gfx backend function \"%s\" is not defined"), func_name);
}

void
lw6gfx_display_background (lw6gfx_backend_t * backend, lw6gui_look_t * look)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_background)
    {
      backend->display_background (backend->gfx_context, look);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_hud (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		    lw6ker_game_state_t * game_state)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_hud)
    {
      backend->display_hud (backend->gfx_context, look, game_state);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_poll_key (lw6gfx_backend_t * backend, lw6gui_keypress_t * keypress)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_key)
    {
      ret = backend->poll_key (backend->gfx_context, keypress);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  return ret;

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_is_key_esc (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->is_key_esc)
    {
      ret = backend->is_key_esc (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_is_key_enter (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->is_key_enter)
    {
      ret = backend->is_key_enter (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_is_key_up (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->is_key_up)
    {
      ret = backend->is_key_up (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_is_key_down (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->is_key_down)
    {
      ret = backend->is_key_down (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_is_key_left (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->is_key_left)
    {
      ret = backend->is_key_left (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_is_key_right (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->is_key_right)
    {
      ret = backend->is_key_right (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_quit (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_quit)
    {
      ret = backend->poll_quit (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_send_quit (lw6gfx_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->send_quit)
    {
      backend->send_quit (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_get_default_keys_state (lw6gfx_backend_t * backend, int *up, int *down,
			       int *left, int *right, int *esc, int *enter)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_default_keys_state)
    {
      backend->get_default_keys_state (backend->gfx_context, up, down, left,
				       right, esc, enter);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_get_key_state (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_key_state)
    {
      ret = backend->get_key_state (backend->gfx_context, keysym);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_mouse_move (lw6gfx_backend_t * backend, int *x, int *y)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_mouse_move)
    {
      ret = backend->poll_mouse_move (backend->gfx_context, x, y);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_mouse_button_left (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_mouse_button_left)
    {
      ret = backend->poll_mouse_button_left (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_mouse_button_right (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_mouse_button_right)
    {
      ret = backend->poll_mouse_button_right (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_mouse_wheel_up (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_mouse_wheel_up)
    {
      ret = backend->poll_mouse_wheel_up (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_mouse_wheel_down (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_mouse_wheel_down)
    {
      ret = backend->poll_mouse_wheel_down (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_get_mouse_state (lw6gfx_backend_t * backend, int *x, int *y,
			int *button_left, int *button_right)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_mouse_state)
    {
      backend->get_mouse_state (backend->gfx_context, x, y, button_left,
				button_right);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_warp_mouse (lw6gfx_backend_t * backend, int x, int y)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->warp_mouse)
    {
      ret = backend->warp_mouse (backend->gfx_context, x, y);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_show_mouse (lw6gfx_backend_t * backend, int state)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->show_mouse)
    {
      backend->show_mouse (backend->gfx_context, state);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_poll_joystick_up (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_joystick_up)
    {
      ret = backend->poll_joystick_up (backend->gfx_context, i);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_joystick_down (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_joystick_down)
    {
      ret = backend->poll_joystick_down (backend->gfx_context, i);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_joystick_left (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_joystick_left)
    {
      ret = backend->poll_joystick_left (backend->gfx_context, i);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_joystick_right (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_joystick_right)
    {
      ret = backend->poll_joystick_right (backend->gfx_context, i);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_poll_joystick_button (lw6gfx_backend_t * backend, int i, int b)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->poll_joystick_button)
    {
      ret = backend->poll_joystick_button (backend->gfx_context, i, b);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_get_joystick_state (lw6gfx_backend_t * backend, int *x, int *y,
			   int *button_a, int *button_b, int i, int b1,
			   int b2)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_joystick_state)
    {
      backend->get_joystick_state (backend->gfx_context, x, y, button_a,
				   button_b, i, b1, b2);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_log (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		    char **log_list)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_log)
    {
      backend->display_log (backend->gfx_context, look, log_list);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_fps (lw6gfx_backend_t * backend, lw6gui_look_t * look, int fps)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_fps)
    {
      backend->display_fps (backend->gfx_context, look, fps);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_map_preview (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			    lw6map_level_t * level)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_map_preview)
    {
      backend->display_map_preview (backend->gfx_context, look, level);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_map_zones (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			  lw6ker_game_struct_t * game_struct)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_map_zones)
    {
      backend->display_map_zones (backend->gfx_context, look, game_struct);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_map_gradient (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			     lw6ker_game_state_t * game_state, int team_id)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_map_gradient)
    {
      backend->display_map_gradient (backend->gfx_context, look, game_state,
				     team_id);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_game (lw6gfx_backend_t * backend,
		     lw6gui_look_t * look, lw6ker_game_state_t * game_state)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_game)
    {
      backend->display_game (backend->gfx_context, look, game_state);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_cursors (lw6gfx_backend_t * backend,
			lw6gui_look_t * look,
			lw6ker_game_state_t * game_state)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_cursors)
    {
      backend->display_cursors (backend->gfx_context, look, game_state);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_display_menu (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		     lw6gui_menu_t * menu, float progress)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->display_menu)
    {
      backend->display_menu (backend->gfx_context, look, menu, progress);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_pick_menuitem (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		      int *position, int *scroll, lw6gui_menu_t * menu,
		      int screen_x, int screen_y)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->pick_menuitem)
    {
      backend->pick_menuitem (backend->gfx_context, look, position, scroll,
			      menu, screen_x, screen_y);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_warp_mouse_on_menuitem (lw6gfx_backend_t * backend,
			       lw6gui_look_t * look, lw6gui_menu_t * menu,
			       int position)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->warp_mouse_on_menuitem)
    {
      ret = backend->warp_mouse_on_menuitem (backend->gfx_context, look, menu,
					     position);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_center_menu (lw6gfx_backend_t * backend,
		    lw6gui_look_t * look, lw6gui_menu_t * menu, int position)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->center_menu)
    {
      backend->center_menu (backend->gfx_context, look, menu, position);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_prepare_buffer (lw6gfx_backend_t * backend, lw6gui_look_t * look)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->prepare_buffer)
    {
      backend->prepare_buffer (backend->gfx_context, look);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_swap_buffers (lw6gfx_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->swap_buffers)
    {
      backend->swap_buffers (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_init (lw6gfx_backend_t * backend, int width,
	     int height, int fullscreen,
	     void (*resize_callback) (int width, int height, int fullscreen),
	     int ticks, int key_repeat_delay, int key_repeat_interval)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->init)
    {
      backend->gfx_context =
	backend->init (backend->argc, backend->argv, width, height,
		       fullscreen, resize_callback, ticks, key_repeat_delay,
		       key_repeat_interval);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return backend->gfx_context ? 1 : 0;
}

int
lw6gfx_set_key_repeat (lw6gfx_backend_t * backend, int key_repeat_delay,
		       int key_repeat_interval)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->set_key_repeat)
    {
      ret =
	backend->set_key_repeat (backend->gfx_context, key_repeat_delay,
				 key_repeat_interval);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_get_low_resolution (lw6gfx_backend_t * backend, int *width,
			   int *height)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_low_resolution)
    {
      backend->get_low_resolution (backend->gfx_context, width, height);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_get_standard_resolution (lw6gfx_backend_t * backend, int *width,
				int *height)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_standard_resolution)
    {
      backend->get_standard_resolution (backend->gfx_context, width, height);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_get_high_resolution (lw6gfx_backend_t * backend, int *width,
			    int *height)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_high_resolution)
    {
      backend->get_high_resolution (backend->gfx_context, width, height);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_set_video_mode (lw6gfx_backend_t * backend, int width, int height,
		       int fullscreen, void (*resize_callback) (int width,
								int height,
								int
								fullscreen))
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->set_video_mode)
    {
      ret =
	backend->set_video_mode (backend->gfx_context, width, height,
				 fullscreen, resize_callback);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

int
lw6gfx_get_video_mode (lw6gfx_backend_t * backend, int *width, int *height,
		       int *fullscreen)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_video_mode)
    {
      ret =
	backend->get_video_mode (backend->gfx_context, width, height,
				 fullscreen);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}

void
lw6gfx_quit (lw6gfx_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->quit)
    {
      backend->quit (backend->gfx_context);
      backend->gfx_context = NULL;
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

void
lw6gfx_delay (lw6gfx_backend_t * backend, int ms)
{
  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->delay)
    {
      backend->delay (backend->gfx_context, ms);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;
}

int
lw6gfx_get_ticks (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCTION_BEGIN;

  if (backend->get_ticks)
    {
      ret = backend->get_ticks (backend->gfx_context);
    }
  else
    {
      _warning (__FUNCTION__);
    }

  LW6SYS_BACKEND_FUNCTION_END;

  return ret;
}
