/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "../../../gfx.h"
#include "../../../../cfg/cfg.h"
#include "gl-bubbles.h"
#include "gl-bubbles-internal.h"

#define CONST_FILE "background/bubbles/gl-bubbles-const.xml"

#define IMAGE_DIR "background/bubbles/image/"

#define IMAGE_BACKGROUND "fumes.png"
#define IMAGE_BUBBLE "bubble.png"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  _mod_gl_background_bubbles_const_data_t *const_data;

  const_data = (_mod_gl_background_bubbles_const_data_t *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, "nb-bubbles", &const_data->nb_bubbles);
    }

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "yspeed", &const_data->yspeed);
      lw6cfg_read_xml_float (key, value, "bubble-yspeed",
			     &const_data->bubble_yspeed);
      lw6cfg_read_xml_float (key, value, "bubble-size-min",
			     &const_data->bubble_size_min);
      lw6cfg_read_xml_float (key, value, "bubble-size-max",
			     &const_data->bubble_size_max);
    }
}

static int
load_consts (mod_gl_utils_context_t * utils_context,
	     _mod_gl_background_bubbles_context_t * bubbles_context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_path_concat (utils_context->path.data_dir, CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("reading \"%s\""), const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *)
					&(bubbles_context->const_data));

      LW6SYS_FREE (const_file);
    }

  return ret;
}

static void
unload_consts (mod_gl_utils_context_t * utils_context,
	       _mod_gl_background_bubbles_context_t * bubbles_context)
{
  memset (&bubbles_context->const_data, 0,
	  sizeof (_mod_gl_background_bubbles_const_data_t));
}

/*
 * Loads images from disk.
 */
static int
load_images (mod_gl_utils_context_t * utils_context,
	     _mod_gl_background_bubbles_context_t * bubbles_context)
{
  int ret = 0;

  lw6sys_log (LW6SYS_LOG_INFO, _("loading images"));

  ret =
    ((bubbles_context->image_data.background =
      mod_gl_utils_load_image (utils_context,
			       IMAGE_DIR IMAGE_BACKGROUND)) != NULL)
    &&
    ((bubbles_context->image_data.bubble =
      mod_gl_utils_load_image (utils_context,
			       IMAGE_DIR IMAGE_BUBBLE)) != NULL);

  if (!ret)
    {
      /*
       * If we can't load images, we simply exit the game...
       */
      exit (1);
    }

  return ret;
}

/*
 * Free memory.
 */
static void
unload_images (mod_gl_utils_context_t * utils_context,
	       _mod_gl_background_bubbles_context_t * bubbles_context)
{
  mod_gl_utils_unload_image (utils_context,
			     bubbles_context->image_data.background);
  mod_gl_utils_unload_image (utils_context,
			     bubbles_context->image_data.bubble);

  memset (&bubbles_context->image_data, 0,
	  sizeof (_mod_gl_background_bubbles_image_data_t));
}

/*
 * Loads textures from disk.
 */
static int
load_textures (mod_gl_utils_context_t * utils_context,
	       _mod_gl_background_bubbles_context_t * bubbles_context)
{
  int ret = 0;
  lw6gui_look_t *default_look;

  default_look = lw6gui_look_new (NULL);
  if (default_look)
    {
      ret =
	_mod_gl_background_bubbles_colorize (utils_context, bubbles_context,
					     default_look);
      lw6gui_look_free (default_look);
    }

  return ret;
}

/*
 * Free memory.
 */
static void
unload_textures (mod_gl_utils_context_t * utils_context,
		 _mod_gl_background_bubbles_context_t * bubbles_context)
{
  mod_gl_utils_unload_texture (utils_context,
			       bubbles_context->texture_data.background);
  mod_gl_utils_unload_texture (utils_context,
			       bubbles_context->texture_data.bubble);
}

/*
 * Putting all the load/unload functions together
 */
int
_mod_gl_background_bubbles_load_data (mod_gl_utils_context_t * utils_context,
				      _mod_gl_background_bubbles_context_t *
				      bubbles_context)
{
  return load_consts (utils_context, bubbles_context) &&
    load_images (utils_context, bubbles_context) &&
    load_textures (utils_context, bubbles_context);
}

void
_mod_gl_background_bubbles_unload_data (mod_gl_utils_context_t *
					utils_context,
					_mod_gl_background_bubbles_context_t *
					bubbles_context)
{
  unload_consts (utils_context, bubbles_context);
  unload_images (utils_context, bubbles_context);
  unload_textures (utils_context, bubbles_context);
}
