/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <time.h>

#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

int
mod_gl_utils_joystick_init (mod_gl_utils_joysticks_state_t * joysticks_state)
{
  int ret = 0;
  int i;

  joysticks_state->driver_nb_joysticks = SDL_NumJoysticks ();
  lw6sys_log (LW6SYS_LOG_INFO, _("%d joystick(s) initialized"),
	      joysticks_state->driver_nb_joysticks);
  for (i = 0; i < joysticks_state->driver_nb_joysticks; ++i)
    {
      if (i < MOD_GL_NB_JOYSTICKS)
	{
	  joysticks_state->joystick_state[i].sdl_joystick =
	    SDL_JoystickOpen (i);
	  if (joysticks_state->joystick_state[i].sdl_joystick)
	    {
	      lw6sys_log (LW6SYS_LOG_INFO, _("joystick %d \"%s\" enabled"), i,
			  SDL_JoystickName (i));
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING,
			  _
			  ("unable to initialize joystick %d \"%s\" enabled"),
			  i, SDL_JoystickName (i));
	    }
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_NOTICE,
		      _
		      ("joystick %d \"%s\" ignored, only %d joysticks supported"),
		      i, SDL_JoystickName (i), MOD_GL_NB_JOYSTICKS);
	}
    }

  SDL_JoystickEventState (SDL_ENABLE);

  return ret;
}

void
mod_gl_utils_joystick_quit (mod_gl_utils_joysticks_state_t * joysticks_state)
{
  int i;

  for (i = 0;
       i < joysticks_state->driver_nb_joysticks && i < MOD_GL_NB_JOYSTICKS;
       ++i)
    {
      if (joysticks_state->joystick_state[i].sdl_joystick)
	{
	  lw6sys_log (LW6SYS_LOG_INFO, _("joystick %d \"%s\" disabled"), i,
		      SDL_JoystickName (i));
	  SDL_JoystickClose (joysticks_state->joystick_state[i].sdl_joystick);
	}
    }
}
