/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

GLuint
mod_gl_utils_texture_1x1_color2texture (mod_gl_utils_context_t *
					utils_context,
					lw6sys_color_8_t color_8)
{
  GLuint texture = 0;
  SDL_Surface *surface = NULL;
  SDL_Color color;

  surface = mod_gl_utils_create_surface (utils_context, 1, 1);
  if (surface)
    {
      color = mod_gl_utils_color_8_to_sdl (color_8);
      mod_gl_utils_clear_surface_with_color (surface, color);
      texture = mod_gl_utils_surface2texture (utils_context, surface);
      mod_gl_utils_delete_surface (utils_context, surface);
    }

  return texture;
}

int
mod_gl_utils_texture_1x1_update (mod_gl_utils_context_t * utils_context,
				 lw6gui_look_t * look)
{
  int ret = 1;

  mod_gl_utils_texture_1x1_clear (utils_context);

  utils_context->textures_1x1.menu_fg =
    mod_gl_utils_texture_1x1_color2texture (utils_context,
					    look->style.
					    menu_color_default.fg);
  utils_context->textures_1x1.menu_bg =
    mod_gl_utils_texture_1x1_color2texture (utils_context,
					    look->style.
					    menu_color_default.bg);
  utils_context->textures_1x1.menu_fg_disabled =
    mod_gl_utils_texture_1x1_color2texture (utils_context,
					    look->style.
					    menu_color_disabled.fg);
  utils_context->textures_1x1.menu_bg_disabled =
    mod_gl_utils_texture_1x1_color2texture (utils_context,
					    look->style.
					    menu_color_disabled.bg);
  utils_context->textures_1x1.menu_fg_selected =
    mod_gl_utils_texture_1x1_color2texture (utils_context,
					    look->style.
					    menu_color_selected.fg);
  utils_context->textures_1x1.menu_bg_selected =
    mod_gl_utils_texture_1x1_color2texture (utils_context,
					    look->style.
					    menu_color_selected.bg);

  return ret;
}

void
mod_gl_utils_texture_1x1_clear (mod_gl_utils_context_t * utils_context)
{
  if (glIsTexture (utils_context->textures_1x1.menu_fg))
    {
      mod_gl_utils_delete_texture (utils_context,
				   utils_context->textures_1x1.menu_fg);
    }
  if (glIsTexture (utils_context->textures_1x1.menu_bg))
    {
      mod_gl_utils_delete_texture (utils_context,
				   utils_context->textures_1x1.menu_bg);
    }
  if (glIsTexture (utils_context->textures_1x1.menu_fg_disabled))
    {
      mod_gl_utils_delete_texture (utils_context,
				   utils_context->
				   textures_1x1.menu_fg_disabled);
    }
  if (glIsTexture (utils_context->textures_1x1.menu_bg_disabled))
    {
      mod_gl_utils_delete_texture (utils_context,
				   utils_context->
				   textures_1x1.menu_bg_disabled);
    }
  if (glIsTexture (utils_context->textures_1x1.menu_fg_selected))
    {
      mod_gl_utils_delete_texture (utils_context,
				   utils_context->
				   textures_1x1.menu_fg_selected);
    }
  if (glIsTexture (utils_context->textures_1x1.menu_bg_selected))
    {
      mod_gl_utils_delete_texture (utils_context,
				   utils_context->
				   textures_1x1.menu_bg_selected);
    }
}
