/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "gui.h"

typedef struct resolution_sort_s
{
  lw6sys_wh_t wh;
  int distance;
} resolution_sort_t;

static int
resolution_sort_callback (lw6sys_list_t ** list_a, lw6sys_list_t ** list_b)
{
  int ret = 0;
  resolution_sort_t *a, *b;

  a = (resolution_sort_t *) ((*list_a)->data);
  b = (resolution_sort_t *) ((*list_b)->data);

  if (a->distance < b->distance)
    {
      ret = -1;
    }
  else if (a->distance > b->distance)
    {
      ret = 1;
    }

  return ret;
}

static void
resolution_copy_callback (void *func_data, void *data)
{
  lw6sys_list_t **target = (lw6sys_list_t **) func_data;
  lw6sys_wh_t *wh = (lw6sys_wh_t *) data;
  resolution_sort_t *resolution_sort = NULL;

  resolution_sort =
    (resolution_sort_t *) LW6SYS_MALLOC (sizeof (resolution_sort_t));
  if (resolution_sort)
    {
      resolution_sort->wh = (*wh);
      resolution_sort->distance = 0;
      lw6sys_lifo_push (target, resolution_sort);
    }
}

static void
resolution_distance_callback (void *func_data, void *data)
{
  lw6sys_wh_t *wished = (lw6sys_wh_t *) func_data;
  resolution_sort_t *resolution_sort = (resolution_sort_t *) data;

  resolution_sort->distance =
    (wished->w - resolution_sort->wh.w) * (wished->w -
					   resolution_sort->wh.w) +
    (wished->h - resolution_sort->wh.h) * (wished->h - resolution_sort->wh.h);
}

/**
 * lw6gui_resolution_find_closest
 *
 * @closest: the closest resolution found
 * @wished: the wished resolution
 * @available: a list of available resolutions (list of lw6sys_wh_t *)
 *
 * Finds the closest resolution available, this is just a small utility
 * to cope with different screen shapes and avoid requesting 640x480 when
 * it's just not available but there's a 640x400 instead.
 *
 * Return value: 1 if the wished resolution exists in available list
 *   and was found, else 0 if the wished resolution doesn't exist and
 *   an approximative match was picked.
 */
int
lw6gui_resolution_find_closest (lw6sys_wh_t * closest, lw6sys_wh_t * wished,
				lw6sys_list_t * available)
{
  int ret = 0;
  lw6sys_list_t *sorted = NULL;

  closest->w = wished->w;
  closest->h = wished->h;

  sorted = lw6sys_list_new (lw6sys_free_callback);
  if (sorted)
    {
      if (available)
	{
	  lw6sys_list_map (available, &resolution_copy_callback, &sorted);
	  lw6sys_list_map (sorted, &resolution_distance_callback, wished);
	  lw6sys_sort (&sorted, resolution_sort_callback);

	  if (sorted->data)
	    {
	      (*closest) = ((resolution_sort_t *) (sorted->data))->wh;
	    }
	}
      lw6sys_list_free (sorted);
    }

  if (closest->w == wished->w && closest->h == wished->h)
    {
      ret = 1;
    }

  return ret;
}
