/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SND_H
#define LIQUIDWAR6SND_H

#include "../sys/sys.h"
#include "../dyn/dyn.h"
#include "../cfg/cfg.h"

#define LW6SND_NB_SOUNDS 4
typedef enum lw6snd_sound_enum_e
{
  LW6SND_SOUND_SPLASH = 0,
  LW6SND_SOUND_BEEP_VALID = 1,
  LW6SND_SOUND_BEEP_SELECT = 2,
  LW6SND_SOUND_START = 3
}
lw6snd_sound_enum_t;


typedef struct lw6snd_backend_s
{
  lw6dyn_dl_handle_t *dl_handle;
  void *snd_context;
  int argc;
  char **argv;
  u_int32_t id;

  int (*play_sound) (void *snd_context, int sound_id);
  int (*play_music) (void *snd_context, char *music_name);
  void *(*init) (int argc, char *argv[], float sound_volume,
		 float music_volume);
  void (*set_sound_volume) (void *snd_context, float volume);
  void (*set_music_volume) (void *snd_context, float volume);
  void (*quit) (void *snd_context);
}
lw6snd_backend_t;

/*
 * In api.c
 */
extern int lw6snd_play_sound (lw6snd_backend_t * backend, int sound_id);
extern int lw6snd_play_music (lw6snd_backend_t * backend, char *music_name);
extern int lw6snd_init (lw6snd_backend_t * backend, float sound_volume,
			float music_volume);
extern void lw6snd_set_sound_volume (lw6snd_backend_t * backend,
				     float volume);
extern void lw6snd_set_music_volume (lw6snd_backend_t * backend,
				     float volume);
extern void lw6snd_quit (lw6snd_backend_t * backend);

/*
 * In register.c
 */
extern lw6sys_assoc_t *lw6snd_get_backends (int argc, char *argv[]);
extern lw6snd_backend_t *lw6snd_create_backend (int argc, char *argv[],
						char *name);
extern void lw6snd_destroy_backend (lw6snd_backend_t * backend);

/*
 * In test.c
 */
extern int lw6snd_test ();

#endif
