/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sys.h"
#include "sys-internal.h"

/**
 * lw6sys_shape_check_min_max
 *
 * @shape: the dimensions to control
 * @min: the min value for w and h
 * @max: the max value for w and h
 *
 * Will check wether the given shape respects some basic constraints,
 * being not to small and not too big.
 *
 * Return value: 1 if OK, 0 if not.
 */
int
lw6sys_shape_check_min_max (lw6sys_wh_t * shape, int min, int max)
{
  int ret = 0;

  ret = (shape->w >= min && shape->w <= max && shape->h >= min
	 && shape->h <= max);

  return ret;
}

/**
 * lw6sys_shape_check_pos
 *
 * @shape: the boundary box
 * @pos: the position
 *
 * Checks wether position is within the given boundary box.
 *
 * Return value: 1 if OK, 0 if not.
 */
int
lw6sys_shape_check_pos (lw6sys_wh_t * shape, lw6sys_xy_t * pos)
{
  int ret = 0;

  ret = (pos->x >= 0 && pos->x < shape->w && pos->y >= 0
	 && pos->y < shape->h);

  return ret;
}
