;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-display-part-map
  (lambda (look)
    (let (
	  (loaded (lw6-get-game-global "loaded"))
	  )
      (let* (
	     (level (assoc-ref loaded "level"))
	     (game-state-preview (assoc-ref loaded "game-state-preview"))
	     (game-state (assoc-ref loaded "game-state"))
	     (main-cursor (lw6-get-cursor "1"))
	     (main-cursor-id (if main-cursor (hash-ref main-cursor "id") "0"))
	    )
	(cond (game-state-preview
	       (c-lw6gfx-display-game game-state-preview main-cursor-id look))
	      (game-state
	       (c-lw6gfx-display-game game-state main-cursor-id look))
	      (level
	       (c-lw6gfx-display-map-preview level look)))))))

(define lw6-display-part-game
  (lambda (look)
    (let (
	  (pilot (lw6-get-game-global "pilot"))
	  (game-state (lw6-get-game-global "game-state"))
	  (server-id (lw6-get-game-global "server-id"))
	  )
      (if (and pilot game-state server-id)
	  (let* (
		 (round (c-lw6ker-get-rounds game-state))		 
		 (commands (lw6-command-all-local round server-id))
		 (main-cursor (lw6-get-cursor "1"))
		 (main-cursor-id (if main-cursor (hash-ref main-cursor "id") "0"))
		 )	      
	    (begin
	      (c-lw6pil-sync-from-draft game-state pilot)
	      (map (lambda (command) (c-lw6pil-execute-command game-state command))
		   commands)
	      (c-lw6gfx-display-game game-state main-cursor-id look)
	      ;(c-lw6gfx-display-map-gradient game-state 0 0 look)
	      (c-lw6gfx-display-cursors game-state main-cursor-id look)
	      ))))))

(define lw6-display-part-hud
  (lambda (look step)
    (let (
	  (map-source (lw6-get-game-global "map-source"))
	  (game-instance (lw6-get-game-global "game-instance"))
	  )
      (if game-instance
	  (let(
	       (game-state (assoc-ref game-instance "game-state"))
	       )
	    (c-lw6gfx-display-hud game-state step look)
	    )	  
	  (c-lw6gfx-display-hud-preview step look)))))

(define lw6-displat-part-fps
  (lambda (look)
    (if (lw6-config-is-true? lw6def-display-fps)
	(c-lw6gfx-display-fps %lw6-frames-per-sec look)
	)))

(define lw6-display-part-menu
  (lambda (look)
    (let* (
	   (map-source (lw6-get-game-global "map-source"))
	   (menu (lw6-current-menu))
	   (menu-smob (assoc-ref menu "smob"))
	   )
      (if menu-smob (begin
		      (lw6-menu-action menu "on-display")
		      (c-lw6gfx-display-menu menu-smob look))))))

(define lw6-display-func-idle
  (lambda ()
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (begin  
	(c-lw6gfx-prepare-buffer look)
	(c-lw6gfx-display-background look)
	(lw6-display-part-menu look)
	(lw6-displat-part-fps look)
	(c-lw6gfx-display-log 10 look)
	(c-lw6gfx-swap-buffers)
	))))

(define lw6-display-func-preview
  (lambda () 
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (begin  
	(c-lw6gfx-prepare-buffer look)
	(c-lw6gfx-display-background look)
	(lw6-display-part-map look)
	(lw6-display-part-menu look)
	(lw6-displat-part-fps look)
	(c-lw6gfx-display-log 10 look)
	(c-lw6gfx-swap-buffers)
      ))))

(define lw6-display-func-running
  (lambda () 
    (let (
	  (look (lw6-get-game-global "look"))
	  )
      (begin  
	(c-lw6gfx-prepare-buffer look)
	(c-lw6gfx-display-background look)
	(lw6-display-part-game look)
	(lw6-display-part-menu look)
	(lw6-displat-part-fps look)
	(c-lw6gfx-display-log 10 look)
	(c-lw6gfx-swap-buffers)
      ))))

(define lw6-display
  (lambda ()
    (let (
	  (display-func (lw6-get-game-global "display-func"))
	  )
      (if display-func
	  (display-func)
	  )
      )
    )
  )


