/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gfx.h"

#define TEST_WIDTH 640
#define TEST_HEIGHT 480
#define TEST_KEY_REPEAT1 500
#define TEST_KEY_REPEAT2 200
#define TEST_DELAY 10
#define TEST_DURATION_SETUP 100
#define TEST_DURATION_BACKGROUND 2000
#define TEST_DURATION_MENU 3000
#define TEST_MENU_LABEL "My menu"
#define TEST_MENU_COLOR 1
#define TEST_MENU_NB_MENUITEMS 5
#define TEST_MENU_SELECTED_MENUITEM 1
#define TEST_MENU_COLORED_MENUITEM 3
#define TEST_MENU_MAX_DISPLAYED_ITEMS 3
#define TEST_ARGC 1
#define TEST_ARGV0 "prog"

static int
test_resolution (lw6gfx_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    int width = 0;
    int height = 0;

    lw6gfx_get_low_resolution (backend, &width, &height);
    lw6sys_log (LW6SYS_LOG_NOTICE, _("low resolution is %dx%d"), width,
		height);
    lw6gfx_get_standard_resolution (backend, &width, &height);
    lw6sys_log (LW6SYS_LOG_NOTICE, _("best resolution is %dx%d"), width,
		height);
    lw6gfx_get_high_resolution (backend, &width, &height);
    lw6sys_log (LW6SYS_LOG_NOTICE, _("high resolution is %dx%d"), width,
		height);
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static void
resize_callback (int width, int height, int fullscreen)
{
  lw6sys_log (LW6SYS_LOG_NOTICE,
	      _("resize callback called %dx%d fullscreen=%d"), width,
	      height, fullscreen);
}

static int
test_init (lw6gfx_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    int ticks;

    ret = ret
      && lw6gfx_init (backend, TEST_WIDTH, TEST_HEIGHT, 0, resize_callback,
		      0, TEST_KEY_REPEAT1, TEST_KEY_REPEAT2);
    ticks = lw6gfx_get_ticks (backend);
    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_SETUP
	   && !lw6gfx_poll_quit (backend))
      {
	lw6gfx_delay (backend, TEST_DELAY);
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_background (lw6gfx_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    int ticks;
    lw6gui_look_t *look = NULL;

    look = lw6gui_look_new (NULL);
    if (look)
      {
	ticks = lw6gfx_get_ticks (backend);
	while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_BACKGROUND
	       && !lw6gfx_poll_quit (backend))
	  {
	    lw6gfx_prepare_buffer (backend, look);
	    lw6gfx_display_background (backend, look);
	    lw6gfx_swap_buffers (backend);
	    lw6gfx_delay (backend, TEST_DELAY);
	  }
	ticks = lw6gfx_get_ticks (backend);
	while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_BACKGROUND
	       && !lw6gfx_poll_quit (backend))
	  {
	    lw6gfx_prepare_buffer (backend, look);
	    lw6gfx_display_background (backend, look);	// todo, use other bg
	    lw6gfx_swap_buffers (backend);
	    lw6gfx_delay (backend, TEST_DELAY);
	  }
	lw6gui_look_free (look);
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_menu (lw6gfx_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6gui_menuitem_t *menuitem = NULL;
    lw6gui_menu_t *menu = NULL;
    int i;
    char *menuitem_label;
    int ticks;

    lw6gui_look_t *look = NULL;

    look = lw6gui_look_new (NULL);
    if (look)
      {
	menu = lw6gui_menu_new (TEST_MENU_LABEL);
	if (menu)
	  {
	    for (i = 0; i < TEST_MENU_NB_MENUITEMS; ++i)
	      {
		menuitem_label =
		  lw6sys_new_sprintf (_("Test menuitem %d"), i);
		if (menuitem_label)
		  {
		    menuitem =
		      lw6gui_menuitem_new (menuitem_label, TEST_MENU_COLOR, 1,
					   0,
					   i == TEST_MENU_COLORED_MENUITEM);
		    if (menuitem)
		      {
			lw6gui_menu_append (menu, menuitem,
					    lw6gfx_get_ticks (backend));
		      }
		    LW6SYS_FREE (menuitem_label);
		  }
	      }
	    lw6gui_menu_select (menu, TEST_MENU_SELECTED_MENUITEM, 0);
	    ticks = lw6gfx_get_ticks (backend);
	    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_MENU
		   && !lw6gfx_poll_quit (backend))
	      {
		lw6gfx_prepare_buffer (backend, look);
		lw6gfx_display_background (backend, look);
		lw6gfx_display_menu (backend, look, menu,
				     ((float)
				      (lw6gfx_get_ticks (backend) -
				       ticks)) /
				     ((float) TEST_DURATION_MENU));
		lw6gfx_swap_buffers (backend);
		lw6gfx_delay (backend, TEST_DELAY);
	      }
	    lw6gui_menu_free (menu);	// should free the menuitem
	  }
	lw6gui_look_free (look);
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_quit (lw6gfx_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  lw6gfx_quit (backend);

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6gfx_test ()
{
  int ret = 0;
  lw6gfx_backend_t *backend = NULL;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0 };

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6cfg_test ();
      lw6map_test ();
      lw6ker_test ();
      lw6gui_test ();
    }

#ifdef MOD_GL
  backend = lw6gfx_create_backend (argc, argv, "gl");
  if (backend)
    {
      ret = test_init (backend) && test_resolution (backend)
	&& test_background (backend) && test_menu (backend)
	&& test_quit (backend);
      lw6gfx_destroy_backend (backend);
    }
#endif

  return ret;
}
