/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libpng12/png.h>

#include "ldr.h"
#include "ldr-internal.h"

/**
 * lw6ldr_body_read
 * 
 * @body: the body to read, must point to allocated memory
 * @dirname: the directory of the map
 * @param: map parameters
 * @hints: map hints
 * @display_shape: shape of current display (screen resolution)
 * @ratio: wished map ratio
 * @progress: structure to transmit loading progress
 *
 * Reads the map body, that is, all the layers.
 *
 * Return value: 1 if OK, 0 if failed.
 */
int
lw6ldr_body_read (lw6map_body_t * body, char *dirname,
		  lw6map_param_t * param, lw6ldr_hints_t * hints,
		  int display_w, int display_h, float ratio,
		  lw6sys_progress_t * progress)
{
  int ret = 0;
  char *dot_png;
  char *extra_layers_png[LW6MAP_MAX_DEPTH] = { _LW6LDR_FILE_LAYER2_PNG,
    _LW6LDR_FILE_LAYER3_PNG,
    _LW6LDR_FILE_LAYER4_PNG,
    _LW6LDR_FILE_LAYER5_PNG,
    _LW6LDR_FILE_LAYER6_PNG,
    _LW6LDR_FILE_LAYER7_PNG,
    NULL
  };
  int layer;

  lw6map_body_clear (body);

  dot_png = lw6sys_path_concat (dirname, _LW6LDR_FILE_MAP_PNG);
  if (dot_png)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("reading \"%s\""), dot_png);

      ret =
	lw6ldr_layer_read_first (&(body->layers[0]), dot_png, param, hints,
				 display_w, display_h, ratio, progress);
      LW6SYS_FREE (dot_png);
      if (ret)
	{
	  body->shape = body->layers[0].shape;
	  body->shape.d = 1;
	  for (layer = 1; layer < LW6MAP_MAX_DEPTH; ++layer)
	    {
	      dot_png =
		lw6sys_path_concat (dirname, extra_layers_png[layer - 1]);
	      if (dot_png)
		{
		  if (lw6sys_file_exists (dot_png))
		    {
		      lw6sys_log (LW6SYS_LOG_INFO,
				  _("reading extra layer %d \"%s\""), layer,
				  dot_png);
		      ret = ret
			&& lw6ldr_layer_read_next (&(body->layers[layer]),
						   dot_png, body->shape.w,
						   body->shape.h);
		      if (ret)
			{
			  body->shape.d++;
			}
		    }
		  LW6SYS_FREE (dot_png);
		}
	    }
	}
      ret = ret && lw6map_body_check_and_fix_holes (body, &param->rules);
    }

  return ret;
}
