// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef EVENT_H
#define EVENT_H

#include <string>
#include <gtkmm.h>
#include "event-date-region.h"

class Event
{
    public:

        Event(std::string name, std::string genre, EventDateRegion date);

	//! Copy constructor.
        Event(const Event& orig);

        //! Destructor.
        virtual ~Event();
        
        std::string get_name() const {return d_name;};

        std::string get_genre() const {return d_genre;};

        EventDateRegion get_date() const {return d_date;};

        double get_duration() const {return d_date.get_duration();};

    private:

        std::string d_name;
        std::string d_genre;
        EventDateRegion d_date;

};

#endif //EVENT_H
