// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef EVENT_DATE_H
#define EVENT_DATE_H

#include <gtkmm.h>

class EventDateRegion;

class EventDate
{
    public:

        EventDate();

	//! Copy constructor.
        EventDate(const EventDate& orig);

        //! Destructor.
        virtual ~EventDate();

        Glib::Date get_date() const {return date;};
        Glib::TimeVal get_time() const {return timeval;};

        void add_hours(double hours);


        void decrement_to_nearest_interval(double hours);

        std::string to_string(bool ampm = true);
    private:

        Glib::Date date;
        Glib::TimeVal timeval;

};
bool operator<(const EventDate& lhs, const EventDate& rhs);

#endif //EVENT_DATE_H
