// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "event.h"
#include "event-date.h"

Event::Event(std::string name, std::string genre, EventDateRegion date)
  :d_name(name), d_genre(genre), d_date(date)
{
}

Event::Event(const Event& orig)
  :d_name(orig.d_name), d_genre(orig.d_genre), d_date(orig.d_date)
{
}

Event::~Event()
{
}
