// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "host-list.h"
#include "host.h"
#include "file.h"

HostList::HostList()
{
  if (size())
    {
      iterator it = begin();
      active_host = (*it).second;
    }
}

HostList::~HostList()
{
    lClear();
}

void HostList::lErase(iterator it)
{
    delete (*it).second;
    erase(it);
}

void HostList::lClear()
{
    while (!empty())
        lErase(begin());
}

void HostList::remove(Host *ch)
{
  guint32 index = 0;
  for (iterator it = begin(); it != end(); it++)
    {
      if ((*it).second == ch)
	{
	  erase(index);
	  break;
	}
      index++;
    }
}

void HostList::add(Host *ch)
{
  (*this)[ch->get_numeric_identifier()] = ch;
}

Host *HostList::get_next_host()
{

  iterator it;

  if (!active_host)
    {
      it = begin();
    }
  else
    {
      for (it = begin(); it != end(); ++it)
        {
          if ((*it).second == active_host)
            {
              it++;
              break;
            }
        }
    }

  while (it == end())
    {
      if (it == end())
        {
          it = begin();
          continue;
        }
      it++;
    }

  active_host = (*it).second;

  return active_host;
}
