// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "listerola.h"
#include "host-list.h"
#include "host.h"
#include "event.h"
#include "hosted-event-list.h"
#include "load-random-listing.h"

Listerola::Listerola(std::string listings_filename, double num_column_hours, double interval)
{
  listings_file = listings_filename;
  hour_interval = interval;
  EventDateRegion now (num_column_hours);
  now.decrement_to_nearest_interval(hour_interval);
  current_event_time = now;
}

Listerola::~Listerola()
{
}

void Listerola::next()
{
  channels.get_next_host();
}

HostedEventList Listerola::get_events(Host *host)
{
  if (host == NULL)
    host = channels.get_active_host();
  
  return host->get_events (current_event_time);
}

double Listerola::overlap_end(Event *event)
{
  if (event->get_date().straddles(current_event_time.get_ending_date()))
    return event->get_date().overlap_end(current_event_time.get_ending_date());
  else
    return 0.0;
}
      
double Listerola::overlap_start(Event *event)
{
  if (event->get_date().straddles(current_event_time))
    return event->get_date().overlap_start(current_event_time);
  else
    return 0.0;
}

void Listerola::random_fill(int num_channels)
{
  char buf[32];
  snprintf(buf, sizeof(buf), "%d", num_channels);
  LoadRandomListing(get_host_list(), buf, current_event_time);
}
