// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef LISTEROLA_H
#define LISTEROLA_H

#include <gtkmm.h>
#include "event-date-region.h"
#include "host-list.h"
class HostedEventList;

class Host;
class Event;
class HostList;

class Listerola
{
    public:

	//! Default constructor.
	Listerola(std::string listings_file, double column_hours, double hour_interval);

	//! Destructor.
        ~Listerola();

        EventDateRegion get_current_date() const {return current_event_time;};
        void set_current_date(EventDateRegion now) {current_event_time = now;};

        HostedEventList get_events(Host *host = NULL);

        double overlap_end(Event *event);
        double overlap_start(Event *event);

        double get_duration() {return get_current_date().get_duration();};

        double get_interval() {return hour_interval;};

        void next();
    
        void random_fill(int num_channels);

        HostList& get_host_list() {return channels;};

    private:
        HostList channels;

        //! The data file that holds the channel listings.
        std::string listings_file;

        //! The window of time that we're interested in.
        EventDateRegion current_event_time;

        //! The length of each slice of our window in time.
        double hour_interval;
};

#endif //LISTEROLA_H
