//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "config.h"
#include "add-genre-colour-dialog.h"
#include "file.h"

AddGenreColourDialog::AddGenreColourDialog(std::list<std::string> avail_genres)
{
    uncoloured_genres = avail_genres;
    
    Glib::RefPtr<Gtk::Builder> xml
	= Gtk::Builder::create_from_file(File::get_glade_path()
				    + "/listerola-add-genre-colour.gtk");

    xml->get_widget("dialog", dialog);
    xml->get_widget("genre_entry", genre_entry);
    xml->get_widget("genre_colorbutton", genre_colorbutton);

    genres_list = Gtk::ListStore::create(genres_columns);
    xml->get_widget("treeview", genres_treeview);
    genres_treeview->set_model(genres_list);
    genres_treeview->append_column("Genre Name", genres_columns.genre);
    std::list<std::string>::iterator it = uncoloured_genres.begin();
    for (; it != uncoloured_genres.end(); it++)
      {
        add_genre(*it);
      }
    genres_treeview->set_reorderable(false);
    genres_treeview->get_selection()->signal_changed().connect
      (sigc::mem_fun(*this, &AddGenreColourDialog::on_genre_selected));
}

AddGenreColourDialog::~AddGenreColourDialog()
{
  delete dialog;
}

void AddGenreColourDialog::set_parent_window(Gtk::Window &parent)
{
  dialog->set_transient_for(parent);
}

void AddGenreColourDialog::hide()
{
  dialog->hide();
}

int AddGenreColourDialog::run()
{
    dialog->show();
    int response = dialog->run();

    if (response == Gtk::RESPONSE_ACCEPT)
      {
        genre_colour = 
          std::pair<std::string, Gdk::Color>
          (genre_entry->get_text(), genre_colorbutton->get_color());
      }
    return response;
}

void AddGenreColourDialog::add_genre(std::string genre)
{
    Gtk::TreeIter i = genres_list->append();
    (*i)[genres_columns.genre] = genre;
}

void AddGenreColourDialog::on_genre_selected()
{
  Glib::RefPtr<Gtk::TreeSelection> selection = genres_treeview->get_selection();
  Gtk::TreeModel::iterator iterrow = selection->get_selected();

  if (iterrow)
    {
      Gtk::TreeModel::Row row = *iterrow;
      genre_entry->set_text(row[genres_columns.genre]);
    }
}
