//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef FRAMEBOX_H
#define FRAMEBOX_H
#include <gtkmm.h>
#include <string>

class FrameBox: public Gtk::EventBox
{
 public:
     FrameBox(Gtk::HBox *contents, Gdk::Color bg, double row_height, double column_width);
     void set_box_contents(Gtk::HBox *contents);
     void set_background_colour(Gdk::Color background);
    ~FrameBox();

    static Gdk::Color brighten(Gdk::Color col, double factor);
 protected:
    Gtk::HBox *get_contents();
    void update_contents(Gtk::HBox *contents);
    void update_background_colour();
 private:
    Gdk::Color background_colour;
    double height;
    double width;


};

#endif
