// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef HOSTLISTLOADER_H
#define HOSTLISTLOADER_H

#include <string>
#include <sigc++/signal.h>
#include "host-list.h"
#include "event-date.h"
#include "listerola-options.h"

//!Abstract class for objects that populate host lists.
class HostListLoader
{
    public:
        HostListLoader(HostList &hosts, std::string file, 
                       EventDate starting_time, ListerolaOptions::Source kind,
                       bool &broken);
        virtual ~HostListLoader();

        virtual void set_listing_file(std::string file);

        virtual bool reload();

        ListerolaOptions::Source get_kind() const {return kind;};

        sigc::signal<void> bad_file_format;
    protected:
        HostList &hostlist;
        std::string filename;
        EventDate starting_at;
        ListerolaOptions::Source kind;
};

#endif //HOSTLISTLOADER_H
