// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "host.h"
#include "event-date.h"
#include "hosted-event-list.h"

Host::Host(std::string name)
{
  d_numeric_identifier = -1;
  d_name = name;
  d_friendly_name = "";
}

Host::Host(const Host& orig)
:std::list<Event*>(orig), d_name(orig.d_name), d_numeric_identifier(orig.d_numeric_identifier)
{
}

Host::~Host()
{
  lClear();
}


void Host::lErase(iterator it)
{
    delete (*it);
    erase(it);
}

void Host::lClear()
{
    while (!empty())
        lErase(begin());
}
void Host::add(Event *event)
{
  push_back(event);
}

bool Host::by_date(const Event*lhs, const Event*rhs)
{
  if (lhs->get_date() < rhs->get_date())
    return true;
  else
    return false;
}

HostedEventList Host::get_events(EventDate now)
{
  HostedEventList events(this);
  for (iterator it = begin(); it != end(); it++)
    {
      if (now < (*it)->get_date() || (*it)->get_date().straddles(now))
        events.push_back(*it);
    }
  return events;
}
        
void Host::get_genres(std::list<std::string> &genres)
{
  for (iterator it = begin(); it != end(); it++)
    {
      if (std::find(genres.begin(), genres.end(), 
                    (*it)->get_genre()) == genres.end())
        genres.push_back((*it)->get_genre());
    }
}
