// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "config.h"
#include "listerola-config-loader.h"
#include "listerola-options.h"
#include "listerola-view-options.h"
#include <libxml/tree.h>

bool
ListerolaConfigLoader::load_from_file(std::string file, ListerolaOptions **listerola_opts, ListerolaViewOptions **listerola_view_opts)
{
  xmlDocPtr config_doc;
  xmlNodePtr config_root;

  config_doc = xmlParseFile(file.c_str());
  if (!config_doc)
    return false;

  config_root = xmlDocGetRootElement(config_doc);

  if (!config_root)
    return false;


  if (xmlStrcmp(config_root->name, BAD_CAST PACKAGE_NAME) != 0) {
    xmlFreeDoc(config_doc);
    return false;
  }
  *listerola_opts = new ListerolaOptions();
  *listerola_view_opts = new ListerolaViewOptions();
  char *version_str = (char*) xmlGetProp(config_root, BAD_CAST "version");
  bool valid = false;
  if (!version_str || strcmp(version_str, PACKAGE_VERSION) == 0)
    {
      valid = load_config_0_0_3 (*listerola_opts, *listerola_view_opts, 
                                 config_root);
    }
  else if (strcmp(version_str, "0.0.2") == 0 ||
           strcmp(version_str, "0.0.1") == 0 ||
           strcmp(version_str, "0.0.1") == 0)
    {
      ; //save files didn't exist for these versions.
    }
  
  return valid;
}
      
bool 
ListerolaConfigLoader::load_config_0_0_3 (ListerolaOptions *listerola_options, 
                                          ListerolaViewOptions *listerola_view_options,
                                          xmlNodePtr root)
{
  char *num_rows_str = NULL;
  char *duration_str = NULL;
  char *interval_str = NULL;
  char *flip_interval_str = NULL;
  char *source_xmltv_str = NULL;
  char *source_mrbs_str = NULL;
  char *source_random_str = NULL;
  char *refresh_interval_str = NULL;
  char *scroll_speed_str = NULL;
  char *row_pause_str = NULL;
  char *vertical_step_str = NULL;
  char *background_colour_str = NULL;
  char *host_background_colour_str = NULL;
  char *header_background_colour_str = NULL;
  char *fullscreen_str = NULL;
  char *show_title_str = NULL;
  char *title_str = NULL;
  char *title_background_colour_str = NULL;
  char *event_foreground_colour_str = NULL;
  char *host_foreground_colour_str = NULL;
  char *header_foreground_colour_str = NULL;
  char *title_foreground_colour_str = NULL;
  char *unmatched_genre_background_colour_str = NULL;
  char *show_host_numbers_str = NULL;
  //alright, we have our root pointer.  now what?
  xmlNodePtr child = root->xmlChildrenNode;

  while (child) {
    if (xmlStrcasecmp(child->name, BAD_CAST "num_rows") == 0) {
      num_rows_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "duration") == 0) {
      duration_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "interval") == 0) {
      interval_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "flipahead_interval") == 0) {
      flip_interval_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "source_xmltv") == 0) {
      source_xmltv_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "source_mrbs") == 0) {
      source_mrbs_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "source_random") == 0) {
      source_random_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "refresh_interval") == 0) {
      refresh_interval_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "scroll_speed") == 0) {
      scroll_speed_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "row_pause") == 0) {
      row_pause_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "vertical_step") == 0) {
      vertical_step_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "background_colour") == 0) {
      background_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "host_background_colour") == 0) {
      host_background_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "header_background_colour") == 0) {
      header_background_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "start_in_fullscreen") == 0) {
      fullscreen_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "show_title") == 0) {
      show_title_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "title") == 0) {
      title_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "title_background_colour") == 0) {
      title_background_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "event_foreground_colour") == 0) {
      event_foreground_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "header_foreground_colour") == 0) {
      header_foreground_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "host_foreground_colour") == 0) {
      host_foreground_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "title_foreground_colour") == 0) {
      title_foreground_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "unmatched_genre_background_colour") == 0) {
      unmatched_genre_background_colour_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "show_host_numbers") == 0) {
      show_host_numbers_str = (char*) xmlNodeGetContent(child);
    } else if (xmlStrcasecmp(child->name, BAD_CAST "genre") == 0) {
      char *genre_str = (char*) xmlNodeGetContent(child);
      char *colour_str = (char*) xmlGetProp(child, BAD_CAST "colour");
      listerola_view_options->set_genre_colour(genre_str, 
                                               Gdk::Color(colour_str));
    } else if (xmlStrcasecmp(child->name, BAD_CAST "host_number") == 0) {
      char *host_str = (char*) xmlNodeGetContent(child);
      char *number_str = (char*) xmlGetProp(child, BAD_CAST "number");
      listerola_options->set_host_number(host_str, atoi(number_str));
    } else if (xmlStrcasecmp(child->name, BAD_CAST "host_name") == 0) {
      char *host_str = (char*) xmlNodeGetContent(child);
      char *name_str = (char*) xmlGetProp(child, BAD_CAST "name");
      listerola_options->set_host_name(host_str, name_str);
    }
    child = child->next;
  }
  if (num_rows_str)
    listerola_options->set_num_rows(atof(num_rows_str));
  if (duration_str)
    listerola_options->set_duration(atof(duration_str));
  if (interval_str)
    listerola_options->set_interval(atof(interval_str));
  if (flip_interval_str)
    listerola_options->set_flipahead_interval(atof(flip_interval_str));
  if (source_xmltv_str)
    listerola_options->set_xmltv_listing_file(source_xmltv_str);
  if (source_mrbs_str)
    listerola_options->set_mrbs_listing_file(source_mrbs_str);
  if (source_random_str)
    listerola_options->set_random_listing_file(source_random_str);
  if (refresh_interval_str)
    listerola_view_options->set_refresh_interval(atof(refresh_interval_str));
  if (scroll_speed_str)
    listerola_view_options->set_scroll_speed(atof(scroll_speed_str));
  if (row_pause_str)
    listerola_view_options->set_scroll_row_pause(atof(row_pause_str));
  if (vertical_step_str)
    listerola_view_options->set_vertical_scroll_step(atof(vertical_step_str));
  if (background_colour_str)
    listerola_view_options->set_background_colour(Gdk::Color(background_colour_str));
  if (host_background_colour_str)
    listerola_view_options->set_host_background_colour(Gdk::Color(host_background_colour_str));
  if (header_background_colour_str)
    listerola_view_options->set_header_background_colour(Gdk::Color(header_background_colour_str));
  if (fullscreen_str)
    {
      if (strcasecmp(fullscreen_str, "true") == 0)
        listerola_view_options->set_start_in_fullscreen(true);
      else if (strcasecmp(fullscreen_str, "false") == 0)
        listerola_view_options->set_start_in_fullscreen(false);
      else
        listerola_view_options->set_start_in_fullscreen(atoi(fullscreen_str));
    }
  if (show_title_str)
    {
      if (strcasecmp(show_title_str, "true") == 0)
        listerola_view_options->set_show_title(true);
      else if (strcasecmp(show_title_str, "false") == 0)
        listerola_view_options->set_show_title(false);
      else
        listerola_view_options->set_show_title(atoi(show_title_str));
    }
  if (title_str)
    listerola_view_options->set_title(title_str);
  if (title_background_colour_str)
    listerola_view_options->set_title_background_colour(Gdk::Color(title_background_colour_str));

  if (event_foreground_colour_str)
    listerola_view_options->set_event_foreground_colour(Gdk::Color(event_foreground_colour_str));
  if (header_foreground_colour_str)
    listerola_view_options->set_header_foreground_colour(Gdk::Color(header_foreground_colour_str));
  if (host_foreground_colour_str)
    listerola_view_options->set_host_foreground_colour(Gdk::Color(host_foreground_colour_str));
  if (title_foreground_colour_str)
    listerola_view_options->set_title_foreground_colour(Gdk::Color(title_foreground_colour_str));
  if (unmatched_genre_background_colour_str)
    listerola_view_options->set_unmatched_genre_background_colour(Gdk::Color(unmatched_genre_background_colour_str));
  if (show_host_numbers_str)
    {
      if (strcasecmp(show_host_numbers_str, "true") == 0)
        listerola_view_options->set_show_host_numbers(true);
      else if (strcasecmp(show_host_numbers_str, "false") == 0)
        listerola_view_options->set_show_host_numbers(false);
      else
        listerola_view_options->set_show_host_numbers(atoi(show_host_numbers_str));
    }
  return true;
}
