// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef LISTEROLA_VIEW_OPTIONS_H
#define LISTEROLA_VIEW_OPTIONS_H

#include <sigc++/connection.h>
#include <sigc++/signal.h>
#include <gtkmm.h>
#include <map>
#include <string>

class ListerolaViewOptions
{
    public:

	//! Default constructor.
	ListerolaViewOptions();

        //! Copy constructor.
	ListerolaViewOptions(ListerolaViewOptions &options);

	//! Destructor.
        ~ListerolaViewOptions();

        double get_refresh_interval() const {return refresh_interval;};
        void set_refresh_interval(double interval);
        sigc::signal<void> refresh_interval_changed;


        double get_scroll_speed() const {return scroll_speed;};
        void set_scroll_speed(double speed);
        sigc::signal<void> scroll_speed_changed;

        double get_scroll_row_pause() const {return scroll_row_pause;};
        void set_scroll_row_pause(double pause);
        sigc::signal<void> scroll_row_pause_changed;

        double get_vertical_scroll_step() const {return vertical_scroll_step;};
        void set_vertical_scroll_step(double step);
        sigc::signal<void> vertical_scroll_step_changed;

        Gdk::Color get_background_colour() const {return background_colour;};
        void set_background_colour(Gdk::Color colour);
        sigc::signal<void> background_colour_changed;

        Gdk::Color get_host_background_colour() const {return host_background_colour;};
        void set_host_background_colour(Gdk::Color colour);
        sigc::signal<void> host_background_colour_changed;
        Gdk::Color get_header_background_colour() const {return header_background_colour;};
        void set_header_background_colour(Gdk::Color colour);
        sigc::signal<void> header_background_colour_changed;

        bool get_start_in_fullscreen() const {return start_in_fullscreen;};
        void set_start_in_fullscreen(bool start);
        sigc::signal<void> start_in_fullscreen_changed;

        bool get_show_title() const {return show_title;};
        void set_show_title(bool show);
        sigc::signal<void> show_title_changed;

        std::string get_title() const {return title;};
        void set_title(std::string title);
        sigc::signal<void> title_changed;

        Gdk::Color get_title_background_colour() const {return title_background_colour;};
        void set_title_background_colour(Gdk::Color colour);
        sigc::signal<void> title_background_colour_changed;


        Gdk::Color get_event_foreground_colour() const {return event_foreground_colour;};
        void set_event_foreground_colour(Gdk::Color colour);
        sigc::signal<void> event_foreground_colour_changed;
        Gdk::Color get_header_foreground_colour() const {return header_foreground_colour;};
        void set_header_foreground_colour(Gdk::Color colour);
        sigc::signal<void> header_foreground_colour_changed;
        Gdk::Color get_host_foreground_colour() const {return host_foreground_colour;};
        void set_host_foreground_colour(Gdk::Color colour);
        sigc::signal<void> host_foreground_colour_changed;
        Gdk::Color get_title_foreground_colour() const {return title_foreground_colour;};
        void set_title_foreground_colour(Gdk::Color colour);
        sigc::signal<void> title_foreground_colour_changed;

        Gdk::Color get_genre_colour(std::string genre);
        std::list<std::string> get_genres();
        void set_genre_colour(std::string genre, Gdk::Color colour);
        void clear_genre_colour(std::string genre);
        sigc::signal<void> genre_colours_changed;

        Gdk::Color get_unmatched_genre_background_colour() const {return unmatched_genre_background_colour;};
        void set_unmatched_genre_background_colour(Gdk::Color colour);
        sigc::signal<void> unmatched_genre_background_colour_changed;

        bool get_show_host_numbers() const {return show_host_numbers;};
        void set_show_host_numbers(bool show);
        sigc::signal<void> show_host_numbers_changed;

    private:
        //! how often to reload the file.  in hours.
        double refresh_interval;

        //! The speed at which we scroll rows.  milliseconds pause between pixels.
        double scroll_speed;

        //! The amount of time we wait while showing a row.
        double scroll_row_pause;

        //! How many pixels scroll at a time.  must be a multiple of row_height
        double vertical_scroll_step;

        //! Background colour of the main window
        Gdk::Color background_colour;

        //! Background colour of the channel column.
        Gdk::Color host_background_colour;

        //! Background colour of the header row.
        Gdk::Color header_background_colour;

        //! Background colour of the title text.
        Gdk::Color title_background_colour;

        //! Whether or not we start the program in fullscreen mode.
        bool start_in_fullscreen;

        //! show a big orange title or not
        bool show_title;

        //! custom title text
        std::string title;

        //! Foreground colour of the event rows.
        Gdk::Color event_foreground_colour;

        //! Foreground colour of the header row.
        Gdk::Color header_foreground_colour;

        //! Foreground colour of the channel column.
        Gdk::Color host_foreground_colour;

        //! Foreground colour of the title text.
        Gdk::Color title_foreground_colour;

        //! Map of genre to background colours.
        std::map<std::string, Gdk::Color> genres;

        //! Background colour for unmatched genres.
        Gdk::Color unmatched_genre_background_colour;

        //! Whether or not to show channel numbers.
        bool show_host_numbers;
};

#endif //LISTEROLA_VIEW_OPTIONS_H
