//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef LISTEROLA_WINDOW_H
#define LISTEROLA_WINDOW_H

#include <gtkmm.h>
#include <string>
#include <sigc++/connection.h>
#include "event-date.h"
#include <sigc++/signal.h>
#include "listerola-view-options.h"


class Listerola;
class FrameBox;

class ListerolaWindow
{
 public:
    ListerolaWindow(Listerola &l, ListerolaViewOptions &opts, 
                    Pango::AttrList event_text_attributes,
                    Pango::AttrList host_text_attributes,
                    Pango::AttrList header_text_attributes);

    Gtk::Window *get_window() {return window;};
    void show();
    void hide();
    
    sigc::signal<void> quit_requested;
    sigc::signal<void, std::list<std::string>, std::list<std::string> > open_preferences_requested;
    sigc::signal<void, std::list<std::string> > update_genres_in_preferences_requested;
    sigc::signal<void, std::list<std::string> > update_hosts_in_preferences_requested;
 private:
    Listerola &listerola;
    ListerolaViewOptions &opts;
    Gtk::Window *window;
    Gtk::Viewport *listerola_viewport;
    Gtk::HBox *listing_hbox;
    Gtk::VBox *listing_vbox;
    Gtk::VBox *header_vbox;
    Gtk::HBox *header_hbox;
    Gtk::HBox *scroll_hbox;
    Gtk::VBox *scroll_vbox;
    Gtk::HBox *ad_hbox;
    Gtk::VBox *ad_vbox;
    FrameBox* timebox;
    Gtk::MenuBar *menubar;
    Gtk::MenuItem *fullscreen_menuitem;
    Gtk::MenuItem *quit_menuitem;
    Gtk::MenuItem *preferences_menuitem;
    Gtk::MenuItem *about_menuitem;
    Gtk::Label *title_label;

    //! use this variable to add the on-deck hbox the first time through.
    bool add_more_rows;

    //! The timer connection for the scrolling mechanism.
    sigc::connection scroll_tick_handler;

    //! the timer connection that runs every second.
    sigc::connection second_handler;

    //how tall a scrolling row is in pixels.
    int row_height;

    //how many pixels an hour takes up.
    double hour_width;

    //how many pixels a channel box takes up.
    double channel_width;

    //how tall is the top title row?
    double header_row_height;

    bool window_is_fullscreen;

    Pango::AttrList event_text_attributes;
    Pango::AttrList host_text_attributes;
    Pango::AttrList header_text_attributes;

    //helpers
    void update_listing_file(std::string listing_file);
    void update_scroll_box_size(double rows, double columns);
    void update_scrolling_speed(double tick_speed);
    Gtk::HBox *get_next_row();
    void fill_headers();
    void calculate_heights_and_widths();
    void update_scale_attribute(Pango::AttrList &attrs, double scale);
    void update_background_colour();
    void update_title();
    std::list<std::string> get_uncoloured_genres();

    //! Callbacks
    bool on_vertical_scroll_tick();
    bool on_vertical_scroll_pause();
    bool on_vertical_scroll_resume();
    void on_row_scrolled(Gtk::HBox *row);
    bool on_second_passed();
    void on_column_scrolled();
    void on_window_resized(Gtk::Allocation box);
    void on_fullscreen_activated();
    void on_quit_activated();
    bool on_delete_event(GdkEventAny *e);
    void on_preferences_activated();
    void on_about_activated();
    void on_scroll_speed_changed();
    void on_background_colour_changed();
    void on_genre_colours_changed();
    void on_host_names_changed();

};

#endif
