/*
 * @file xmltv.lib/program.c Program Class
 *
 * atvguide -- a collection of helper libraries and a GTK+ frontend for XMLTV
 * Copyright (C) 2004  Andrew Ayer
 * Copyright (C) 2010  Ben Asselstine
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 * 02110-1301, USA.
*/


#include <libxml/tree.h>
#include <string.h>
#include "xmltv-program.h"
#include "xmltv-date.h"
#include <iostream>

using namespace XmlTv;

program::program ()
{
	start_time = -1;
	end_time = -1;
	title = 0;
	subtitle = 0;
	description = 0;
        category = 0;
	channel = 0;
}

program::~program ()
{
	free(title);
	free(subtitle);
	free(description);
	free(category);
	free(channel);
}

bool	program::init (xmlNodePtr nd)
{
	if (nd) {
		xmlChar *start = xmlGetProp( nd, BAD_CAST "start" );
		xmlChar *stop = xmlGetProp( nd, BAD_CAST "stop" );

		if (start) {
			start_time = tvdate::parse_xmltv_date((char *) start);
			xmlFree(start);
		}
		if (stop) {
			end_time = tvdate::parse_xmltv_date((char *) stop);
			xmlFree(stop);
		} else {
			end_time = start_time + 1800;
		}

		channel = (char*) xmlGetProp(nd, BAD_CAST "channel");

		xmlNodePtr	child = nd->xmlChildrenNode;

		while (child) {
			if (xmlStrcasecmp(child->name, BAD_CAST "title") == 0) {
				title = (char*) xmlNodeGetContent(child);
			} else if (xmlStrcasecmp(child->name, BAD_CAST "sub-title") == 0) {
				subtitle = (char*) xmlNodeGetContent(child);
			} else if (xmlStrcasecmp(child->name, BAD_CAST "desc") == 0) {
				description = (char*) xmlNodeGetContent(child);
			} else if (xmlStrcasecmp(child->name, BAD_CAST "category") == 0) {
				category = (char*) xmlNodeGetContent(child);
			}
			child = child->next;
		}

		return true;
	}

	return false;
}

