/*
 * libmaitretarot.
 * Copyright (C) 2002  Yves Mettier <ymettier@libertysurf.fr>
 * Code taken from the MyAM project, also (c) Yves Mettier
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,  59
 * Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MAITRETAROT_H
#define MAITRETAROT_H

#include <glib.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <sys/types.h>
#include <unistd.h>

#define SERVER_PORT 2551
#define PROTOCOL 1

/* K:King, Q:Queen, C:Cavalier, J:Jack, F:Fool */
/* c:Club/Trefle, s:Spade/Pique, h:Heart/Coeur, d:Diamond/Carreau */

#define CLUB    0
#define SPADE   14
#define HEART   28
#define DIAMOND 42
#define TRUMP   56
#define FOOL    77

#define MAX_PLAYER 5
#define MAX_HAND_CARD 24
#define MAX_CARD_CHIEN 6

#define NUMBER_OF_CARD 78

/* the bet names
 */
typedef enum
{
  LIBMT_BID_PASSE = 0,
  LIBMT_BID_PRISE = 1,
  LIBMT_BID_GARDE = 2,
  LIBMT_BID_SANS = 3,
  LIBMT_BID_CONTRE = 4
}
libmt_bid_e;

#define LIBMT_BID_CMP(a,b) ((a==b)?0:((a<b)?-1:1))


typedef enum
{
  LIBMT_NET_ERROR_GETHOSTBYNAME_FAILED = -1,
  LIBMT_NET_ERROR_SOCKET_CREATION_FAILED = -2,
  LIBMT_NET_ERROR_MEM_ALLOCATION_FAILED = -3,
  LIBMT_NET_ERROR_SOCKET_CONNECT_FAILED = -4
}
libmt_net_error_e;

typedef struct
{
  gchar *buffer;
  gint data_r;
  gint data_w;
  gint buf_len;
  gint id;
  gboolean enabled;
  gboolean an_error_occured;
}
libmt_channel_t;

typedef struct
{
  int sock_id;
  libmt_channel_t **channel;
  GThread *thread_id;
  gboolean active;
}
libmt_channels_set_t;

typedef struct
{
  gint client_id[2];
  gint server_id[2];
  gint protocol_version;
  gint sock;
  libmt_channels_set_t *channels_set;
}
libmt_net_t;

typedef struct
{
  gint type;
  gint value;
}
libmt_net_data_type_t;

typedef enum
{
  LIBMT_NET_DATA_TYPE_NO = 0,
  LIBMT_NET_DATA_TYPE_GET_ID,
  LIBMT_NET_DATA_TYPE_SEND_ID,
  LIBMT_NET_DATA_TYPE_SEND_PROTOCOL,
  LIBMT_NET_DATA_TYPE_GET_PROTOCOL,
  LIBMT_NET_DATA_TYPE_SEND_PLACE,
  LIBMT_NET_DATA_TYPE_GET_NICK_LEN,
  LIBMT_NET_DATA_TYPE_GET_NICK,
  LIBMT_NET_DATA_TYPE_SEND_NICK_LEN,
  LIBMT_NET_DATA_TYPE_SEND_NICKS,
  LIBMT_NET_DATA_TYPE_DILL_CARDS,
  LIBMT_NET_DATA_TYPE_SEND_BIDS,
  LIBMT_NET_DATA_TYPE_GET_BID,
  LIBMT_NET_DATA_TYPE_SEND_FINAL_BIDS,
  LIBMT_NET_DATA_TYPE_SHOW_CHIEN,
  LIBMT_NET_DATA_TYPE_SEND_ACK_FOR_CHIEN,
  LIBMT_NET_DATA_TYPE_SEND_ACK_FOR_CARD,
  LIBMT_NET_DATA_TYPE_GET_CHIEN,
  LIBMT_NET_DATA_TYPE_SEND_TURN_CARDS,
  LIBMT_NET_DATA_TYPE_GET_TURN_CARDS,
  LIBMT_NET_DATA_TYPE_SEND_LAST_TURN_CARDS,
  LIBMT_NET_DATA_TYPE_SEND_SCORE,
  LIBMT_NET_DATA_TYPE_SEND_TURN_CARDS_QUESTION,
  LIBMT_NET_DATA_TYPE_ASK_BID_QUESTION,
  LIBMT_NET_DATA_TYPE_SHOW_CHIEN_AT_END,
  LIBMT_NET_DATA_TYPE_ACK_REPLAY,
  LIBMT_NET_DATA_TYPE_SEND_REPLAY_ANSWER,
  LIBMT_NET_DATA_TYPE_END
}
libmt_net_data_type_e;

/* net functions */
#define LIBMT_NET_ERROR libmt_net_error_quark ()
gint libmt_make_server (guint16 port);
gint libmt_connect_to_socket (gchar * ip, guint16 port, GError ** error);
ssize_t libmt_read (int sock, void *buffer, size_t len);
gpointer libmt_read_data (gint sock, gint data_size);
gint libmt_write_data (gint sock, gpointer data, gint data_size);

/* config functions */
gboolean libmt_check_version (gint major, gint minor, gint micro);

/* OBSOLETE */
gchar *libmt_load_file (gchar * filename);
gchar *libmt_config_get_filename (char *default_name);
int libmt_config_load_config_file (gchar * filename);
const char *libmt_config_get (const char *key);
void libmt_config_test (const gchar ** testkeys);
void libmt_config_free (void);
/* end of obsolete functions */


/* net_consumer functions */
libmt_channels_set_t *libmt_channels_set_new (int sock_id);

/**
 * read some data on a channel
 * \brief read some data on a channel
 * \param c channel set
 * \param channel_id channel ID
 * \param buffer buffer where the data will be stored
 * \param len length of the buffer
 * \return the length read, or -1 if an error occured
 */
ssize_t
libmt_channels_set_read (libmt_channels_set_t * c, gint channel_id,
			 void *buffer, size_t len);

/**
 * write some data on a channel
 * \brief read some data on a channel
 * \param c channel set
 * \param channel_id channel ID
 * \param buffer buffer from where the data is sent
 * \param len length of the buffer
 * \return the length written, or -1 if an error occured
 */
ssize_t
libmt_channels_set_write (libmt_channels_set_t * c, gint channel_id,
			  void *buffer, size_t len);
/**
 * free the channels set
 * \brief free the channels set
 * \param c channel set
 */
void libmt_channels_set_free (libmt_channels_set_t * c);

/**
 * test is the channels set socket is working
 * \brief test is the channels set socket is working
 * \param c channel set
 * \return TRUE if the channels set socket is working, FALSE otherwise
 */
gboolean libmt_channels_set_is_socket_working (libmt_channels_set_t * c);

/**
 * says if there is enough data on a channel
 * \brief give the length of available data on a channel
 * \param c channel set
 * \param channel_id channel ID
 * \param size requested on the channel
 * \return 1 if there is more than size data to read, -1 in case of error, 0 otherwise.
 */
gint
libmt_channels_set_has_enough_data_to_read (libmt_channels_set_t * c,
					    gint channel_id, gint size);
/**
 * test if the channel has errors
 * \brief test if the channel has errors
 * \param c channel set
 * \param channel_id channel ID
 * \return TRUE if an error occured, FALSE otherwise
 */
gboolean 
libmt_channels_set_channel_has_error (libmt_channels_set_t * c,
				      gint channel_id);
/**
 * read the type of the following data
 * \brief read the type of the following data
 * \param c channel set
 * \param channel_id channel ID
 * \param type the type read
 * \return -1 if an error occured, 0 otherwise
 */
gint 
libmt_read_type (libmt_channels_set_t * channels_set,
		 gint channel_id, libmt_net_data_type_t * type);

/**
 * write the type of the following data
 * \brief write the type of the following data
 * \param c channel set
 * \param channel_id channel ID
 * \param type the type to write
 * \return -1 if an error occured, 0 otherwise
 */
gint
libmt_write_type (libmt_channels_set_t * channels_set, gint channel_id,
		  libmt_net_data_type_t * type);


/**
 * test if the type correspond to the expected type
 * \brief test if the type correspond to the expected type
 * \param type type read
 * \param expected_type type expected
 * \param is_verbose TRUE to print the type in case of error
 * \return TRUE if the types correspond, FALSE in case of error
 */
gboolean
libmt_is_type_ok (libmt_net_data_type_t * type,
		libmt_net_data_type_t * expected_type, gboolean is_verbose);

/* libmt_xmlconfig functions */
gboolean libmt_xmlconfig_init_from_string (gchar * xml_config_string);
gboolean libmt_xmlconfig_init_from_file (const gchar * config_file_name);
void libmt_xmlconfig_free (void);
const gchar * libmt_xmlconfig_get_value (gchar * path);
gboolean libmt_xmlconfig_set_value (gchar * path, gchar * content);
gboolean
libmt_xmlconfig_write_file (gchar * filename, gboolean keep_bakup_file);
xmlXPathContextPtr libmt_xmlconfig_get_context (void);
xmlDocPtr libmt_xmlconfig_get_doc (void);

#endif
