/*  MaitreTarot.
 *  (C) 2002 Yves Mettier <ymettier@libertysurf.fr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MT_GTK_CLIENT_CONFIG_UTILS_H
#define MT_GTK_CLIENT_CONFIG_UTILS_H

#include <glib.h>
#include <maitretarot.h>

typedef enum
{
  ARGS_CONFIG_FILE_NAME,
  ARGS_PORT,
  ARGS_UNSET
}

args_e;

typedef struct
{
  gint port;
}
config_t;


extern config_t *config;


gint conf_update_with_command_line (config_t * conf, int argc, char **argv);
void conf_free (config_t * conf);
config_t *config_read (int argc, char **argv);
void config_print (config_t * config);


#define DEFAULT_CONFIG_SERVER_PORT "2551"

#define DEFAULT_CONFIG_STRING "<?xml version=\"1.0\" standalone='yes'?>\n" \
                              "<maitretarot>\n" \
                              "  <server>\n" \
                              "    <port>" DEFAULT_CONFIG_SERVER_PORT "</port>\n" \
                              "  </server>\n" \
                              "</maitretarot>"

#endif
