/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <mt_client.h>
#include <gdk/gdkkeysyms.h>
#include "gui.h"
#include "defs.h"
#include "player.h"
#include "gui_sort_card.h"


gint gui_card_sort[NUMBER_OF_CARD + 1];

static GtkWidget *win;
static GtkWidget *spin[5] = { NULL, NULL, NULL, NULL, NULL };;





void
gui_init_card_sort (void)
{
  gint i;

  for (i = 0; i < NUMBER_OF_CARD + 1; i++)
    gui_card_sort[i] = i;
}


static int
compare (const void *ap, const void *bp)
{
  gint a, b;

  a = *((gint *) ap);
  b = *((gint *) bp);

  if (a >= GUI_CARD_IN_CHIEN)
    a -= GUI_CARD_IN_CHIEN;
  if (b >= GUI_CARD_IN_CHIEN)
    b -= GUI_CARD_IN_CHIEN;

  a = gui_card_sort[a];
  b = gui_card_sort[b];

  if (a < b)
    return (-1);
  if (a > b)
    return (1);

  return (0);
}

void
gui_sort_card (gint * card, gint nb_card)
{
  qsort (card, nb_card, sizeof (gint), compare);
}







static void
gui_reorder_cards (void)
{
  gint i, j;

  for (i = 0; i < NUMBER_OF_CARD + 1; i++)
    {
      gtk_widget_hide_all (gui_card_img[i]);
    }

  if (config->gui_card_ascendant_order == TRUE)
    {
      for (i = 0; i < NUMBER_OF_CARD + 1; i++)
	{
	  for (j = 0; j < NUMBER_OF_CARD + 1; j++)
	    {
	      if (gui_card_sort[j] == i)
		{
		  gtk_widget_show_all (gui_card_img[j]);
		}
	    }
	}
    }
  else
    {
      for (i = NUMBER_OF_CARD; i >= 0; i--)
	{
	  for (j = 0; j < NUMBER_OF_CARD + 1; j++)
	    {
	      if (gui_card_sort[j] == i)
		{
		  gtk_widget_show_all (gui_card_img[j]);
		}
	    }
	}
    }

  gui_do_redraw ();
}




void
gui_sort_card_HCDST (void)
{
  gint i;

  config->gui_card_sort_value[0] = 1;
  config->gui_card_sort_value[1] = 2;
  config->gui_card_sort_value[2] = 3;
  config->gui_card_sort_value[3] = 4;
  config->gui_card_sort_value[4] = 5;

  for (i = 0; i < 5; i++)
    {
      if (spin[i] != NULL)
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin[i]),
				   config->gui_card_sort_value[i]);
    }

  config->gui_card_ascendant_order = TRUE;
  config->gui_card_upper_order = TRUE;

  gui_valide_customize ();
}

void
gui_sort_card_HCTDS (void)
{
  gint i;

  config->gui_card_sort_value[0] = 1;
  config->gui_card_sort_value[1] = 2;
  config->gui_card_sort_value[2] = 4;
  config->gui_card_sort_value[3] = 5;
  config->gui_card_sort_value[4] = 3;

  for (i = 0; i < 5; i++)
    {
      if (spin[i] != NULL)
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin[i]),
				   config->gui_card_sort_value[i]);
    }

  gui_valide_customize ();
}


void
gui_sort_card_THCDS (void)
{
  gint i;

  config->gui_card_sort_value[0] = 2;
  config->gui_card_sort_value[1] = 3;
  config->gui_card_sort_value[2] = 4;
  config->gui_card_sort_value[3] = 5;
  config->gui_card_sort_value[4] = 1;

  for (i = 0; i < 5; i++)
    {
      if (spin[i] != NULL)
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin[i]),
				   config->gui_card_sort_value[i]);
    }

  config->gui_card_ascendant_order = FALSE;
  config->gui_card_upper_order = FALSE;

  gui_valide_customize ();
}


void
gui_sort_card_ascendant (void)
{
  config->gui_card_ascendant_order = TRUE;
  gui_valide_customize ();
}

void
gui_sort_card_descendant (void)
{
  config->gui_card_ascendant_order = FALSE;
  gui_valide_customize ();
}

void
gui_sort_card_upper (void)
{
  config->gui_card_upper_order = TRUE;
  gui_valide_customize ();
}

void
gui_sort_card_lower (void)
{
  config->gui_card_upper_order = FALSE;
  gui_valide_customize ();
}





gboolean
gui_valide_customize (void)
{
  gint i, j, k, ind;
  gboolean ok;

  for (i = 0; i < 5; i++)
    {
      if (spin[i] != NULL)
	config->gui_card_sort_value[i] =
	  gtk_spin_button_get_value (GTK_SPIN_BUTTON (spin[i]));
    }

  for (i = 1; i <= 5; i++)
    {
      ok = FALSE;
      for (j = 0; j < 5; j++)
	{
	  if (config->gui_card_sort_value[j] == i)
	    ok = TRUE;
	}
      if (ok == FALSE)
	break;
    }

  if (ok == TRUE)
    {
      for (i = 0; i < NUMBER_OF_CARD + 1; i++)
	gui_card_sort[i] = i;

      ind = 0;
      for (i = 1; i <= 5; i++)
	{
	  for (j = 0; j < 5; j++)
	    {
	      if (config->gui_card_sort_value[j] == i)
		{
		  switch (j)
		    {
		    case 0:
		      if (config->gui_card_upper_order)
			for (k = 0; k < 14; k++)
			  gui_card_sort[HEART + k] = ind++;
		      else
			for (k = 13; k >= 0; k--)
			  gui_card_sort[HEART + k] = ind++;
		      break;
		    case 1:
		      if (config->gui_card_upper_order)
			for (k = 0; k < 14; k++)
			  gui_card_sort[CLUB + k] = ind++;
		      else
			for (k = 13; k >= 0; k--)
			  gui_card_sort[CLUB + k] = ind++;
		      break;
		    case 2:
		      if (config->gui_card_upper_order)
			for (k = 0; k < 14; k++)
			  gui_card_sort[DIAMOND + k] = ind++;
		      else
			for (k = 13; k >= 0; k--)
			  gui_card_sort[DIAMOND + k] = ind++;
		      break;
		    case 3:
		      if (config->gui_card_upper_order)
			for (k = 0; k < 14; k++)
			  gui_card_sort[SPADE + k] = ind++;
		      else
			for (k = 13; k >= 0; k--)
			  gui_card_sort[SPADE + k] = ind++;
		      break;
		    case 4:
		      if (config->gui_card_upper_order)
			for (k = 0; k < 22; k++)
			  gui_card_sort[TRUMP + k] = ind++;
		      else
			for (k = 21; k >= 0; k--)
			  gui_card_sort[TRUMP + k] = ind++;
		      break;
		    }
		}
	    }
	}

      gui_reorder_cards ();
    }

  return (ok);
}

static void
quit_customize (void)
{
  gint i;

  for (i = 0; i < 5; i++)
    {
      gtk_widget_destroy (spin[i]);
      spin[i] = NULL;
    }
  gtk_widget_destroy (win);
}

static void
customize_and_quit (void)
{
  gui_valide_customize ();

  quit_customize ();
}


void
gui_sort_card_customize (void)
{
  GtkWidget *frame;
  GtkWidget *vglob, *vbox;
  GtkWidget *hbox;
  GtkWidget *wid;
  GString *st[5];
  gint i;
  GtkAccelGroup *accel_group;

  st[0] = g_string_new (_("Heart"));
  st[1] = g_string_new (_("Club"));
  st[2] = g_string_new (_("Diamond"));
  st[3] = g_string_new (_("Spade"));
  st[4] = g_string_new (_("Trump"));

  /* Top window */
  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (win), "Maitretarot GTK+ Client");

  accel_group = gtk_accel_group_new ();
  gtk_window_add_accel_group (GTK_WINDOW (win), accel_group);

  /* Global verticale box */
  vglob = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (win), vglob);
  gtk_container_set_border_width (GTK_CONTAINER (vglob), 5);

  /* Standard sort */
  frame = gtk_frame_new (_("Standard sort"));
  gtk_box_pack_start (GTK_BOX (vglob), frame, FALSE, FALSE, 5);

  hbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

  wid = gtk_button_new_with_label (_("Heart-Club-Diamond-Spade-Trump"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_HCDST), NULL);

  wid = gtk_button_new_with_label (_("Heart-Club-Trump-Diamond-Spade"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_HCTDS), NULL);

  wid = gtk_button_new_with_label (_("Trump-Heart-Club-Diamond-Spade"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_THCDS), NULL);

  /* Customize sort */
  frame = gtk_frame_new (_("Personal card order"));
  gtk_box_pack_start (GTK_BOX (vglob), frame, FALSE, FALSE, 5);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);

  for (i = 0; i < 5; i++)
    {
      hbox = gtk_hbox_new (TRUE, 5);
      gtk_container_add (GTK_CONTAINER (vbox), hbox);

      wid = gtk_label_new (st[i]->str);
      gtk_box_pack_start (GTK_BOX (hbox), wid, TRUE, TRUE, 5);

      spin[i] = gtk_spin_button_new_with_range (1, 5, 1);
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin[i]),
				 config->gui_card_sort_value[i]);
      gtk_box_pack_start (GTK_BOX (hbox), spin[i], TRUE, TRUE, 5);
    }

  /* Manipulate cards */
  frame = gtk_frame_new (_("Manipulate cards"));
  gtk_box_pack_start (GTK_BOX (vglob), frame, FALSE, FALSE, 5);

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);

  hbox = gtk_hbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

  wid = gtk_button_new_with_label (_("Ascendant Order"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_ascendant), NULL);

  wid = gtk_button_new_with_label (_("Descendant Order"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_descendant), NULL);

  hbox = gtk_hbox_new (TRUE, 5);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

  wid = gtk_button_new_with_label (_("Upper Order"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_upper), NULL);

  wid = gtk_button_new_with_label (_("Lower Order"));
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (G_OBJECT (wid), "clicked",
		    G_CALLBACK (gui_sort_card_lower), NULL);

  /* Validate buttons */
  hbox = gtk_hbox_new (TRUE, 5);
  gtk_box_pack_start (GTK_BOX (vglob), hbox, FALSE, FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);

  wid = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (wid, "clicked", G_CALLBACK (customize_and_quit),
			    NULL);

  gtk_widget_add_accelerator (wid, "clicked", accel_group,
			      GDK_Return, 0, GTK_ACCEL_VISIBLE);

  wid = gtk_button_new_from_stock (GTK_STOCK_APPLY);
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (wid, "clicked", G_CALLBACK (gui_valide_customize),
			    NULL);

  wid = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 5);
  g_signal_connect (wid, "clicked", G_CALLBACK (quit_customize),
			    NULL);

  gtk_widget_add_accelerator (wid, "clicked", accel_group,
			      GDK_Escape, 0, GTK_ACCEL_VISIBLE);


  gtk_widget_show_all (win);


  for (i = 0; i < 5; i++)
    g_string_free (st[i], TRUE);
}
