/*  MaitreTarot.
 *  (C) 2002 Yves Mettier <ymettier@libertysurf.fr
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MT_GTK_CLIENT_CONFIG_UTILS_H
#define MT_GTK_CLIENT_CONFIG_UTILS_H

#include <glib.h>
#include <maitretarot.h>

typedef enum
{
  ARGS_CONFIG_FILE_NAME,
  ARGS_PORT,
  ARGS_PLAYERNAME,
  ARGS_GEOMETRY,
  ARGS_SERVER,
  ARGS_UNSET
}

args_e;

#define GUI_CARD_SORT_UNDEF -1
#define GUI_COMMAND_SERVER_DELAY_UNDEF -1
#define COMMAND_LINE_PROG_UNDEF -1


/* typedef struct */
/* { */
/*   gint prog;			/\* identifier of program *\/ */
/*   GString *command;		/\* command line *\/ */
/*   gboolean start;		/\* start in all programs window *\/ */
/* } */
/* command_line_t; */

typedef struct
{
  gchar *config_file_name;

  gboolean gui_start_screen;

  GString *gui_host_name;
  gint gui_port;
  GString *gui_player_name;
  GString *gui_geometry;
  GString *gui_info_geometry;
  GString *gui_layout_bg_color;
  GString *gui_taker_bid_color;
  GString *gui_other_bid_color;

  GString *cardpics_dir;

  GString *gui_command[4];
  gint gui_command_server_delay;

  gboolean gui_card_ascendant_order;
  gboolean gui_card_upper_order;
  gint gui_card_sort_value[5];
}
config_t;


extern config_t *config;


gint conf_update_with_command_line (config_t * conf, int argc, char **argv);
void conf_free (config_t * conf);
config_t *config_read (int argc, char **argv);
gint config_write (GError ** error);
void config_print (config_t * config);

#endif
