/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libintl.h>
#define _(a) gettext (a)
#define N_(a) a

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <libmt_client.h>
#include "player.h"
#include "defs.h"
#include "gui.h"


static gint done;

static GtkWidget *button_ok;



typedef struct
{
  /* if card is in chien, card=card+CARD_IN_CHIEN */
  gint card[MAX_HAND_CARD + MAX_CARD_CHIEN];

  libmt_client_player_t *player;
}
player_data_t;


typedef struct
{
  gint card;
  player_data_t *tot_card;
}
player_clicked_data_t;



static void
ok_seen_chien (GtkButton * button, gpointer data)
{
  done = 1;

  printf ("done = %d\n", done);
}



static void
chien_redraw (GtkWidget * win, GdkEventConfigure * evt, gpointer data)
{
  gint width, height;
  GtkRequisition req;
  gfloat px;
  gint i;
  player_data_t *tot_card = data;
  gint nb_hand, nb_chien;
  gint ih, ic;

  gui_layout_get_size (evt, &width, &height);

  player_client_redraw_frame_name (tot_card->player, width, height);

  gui_sort_card (tot_card->card,
		 tot_card->player->nb_hand_card +
		 tot_card->player->nb_chien_card);

  nb_hand = 0;
  nb_chien = 0;
  for (i = 0;
       i < tot_card->player->nb_hand_card + tot_card->player->nb_chien_card;
       i++)
    {
      if (tot_card->card[i] >= GUI_CARD_IN_CHIEN)
	nb_chien += 1;
      else
	nb_hand += 1;
    }

  /* display chien cards */
  px = (gfloat) (width - gui_card_width * 2) / (MAX (nb_hand, nb_chien) - 1);

  for (i = 0, ih = 0, ic = 0;
       i < tot_card->player->nb_hand_card + tot_card->player->nb_chien_card;
       i++)
    {
      if (tot_card->card[i] >= GUI_CARD_IN_CHIEN)
	{
	  gtk_layout_move (GTK_LAYOUT (gui_layout),
			   gui_card_img[tot_card->card[i] -
					GUI_CARD_IN_CHIEN],
			   (width - px * (nb_chien - 1) -
			    gui_card_width) / 2 + px * ic,
			   height / 2 - gui_card_height);
	  ic += 1;
	}
      else
	{
	  gtk_layout_move (GTK_LAYOUT (gui_layout),
			   gui_card_img[tot_card->card[i]],
			   (width - px * (nb_hand - 1) - gui_card_width) / 2 +
			   px * ih, height - gui_card_height - 5);
	  ih += 1;
	}
    }

  gtk_widget_size_request (GTK_WIDGET (button_ok), &req);
  gtk_layout_move (GTK_LAYOUT (gui_layout), button_ok,
		   (width - req.width) / 2,
		   height - gui_card_height - 5 * req.height / 2);
  if (nb_chien == 6)
    gtk_widget_set_sensitive (GTK_WIDGET (button_ok), TRUE);
  else
    gtk_widget_set_sensitive (GTK_WIDGET (button_ok), FALSE);

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}


static void
card_clicked (GtkWidget * wid, GdkEventButton * evt_but, gpointer data)
{
  player_clicked_data_t *click_card = data;
  gint i, c;
  libmt_client_player_t *player;

  player = click_card->tot_card->player;

  printf ("card %d clicked\n", click_card->card);

  for (i = 0; i < player->nb_hand_card + player->nb_chien_card; i++)
    {
      /* find the card that has been clicked */
      c = click_card->tot_card->card[i];
      if (c >= GUI_CARD_IN_CHIEN)
	c -= GUI_CARD_IN_CHIEN;

      if (click_card->card == c)
	{
	  if (click_card->tot_card->card[i] >= GUI_CARD_IN_CHIEN)
	    click_card->tot_card->card[i] -= GUI_CARD_IN_CHIEN;
	  else
	    click_card->tot_card->card[i] += GUI_CARD_IN_CHIEN;
	}
    }

  gui_sort_card (click_card->tot_card->card,
		 player->nb_hand_card + player->nb_chien_card);

  gui_do_redraw ();
}




gint
player_client_make_chien (libmt_client_player_t * player)
{
  gint width, height;
  GtkRequisition req;
  gint i, ind;
  gint ih, ic;
  player_data_t tot_card;
  player_clicked_data_t click_card[MAX_HAND_CARD + MAX_CARD_CHIEN];


  /* Place cards */
  tot_card.player = player;

  for (i = 0, ind = 0; i < player->nb_hand_card; i++, ind++)
    tot_card.card[ind] = player->card[i];

  for (i = 0; i < player->nb_chien_card; i++, ind++)
    tot_card.card[ind] = player->chien[i] + GUI_CARD_IN_CHIEN;

  gui_sort_card (tot_card.card, player->nb_hand_card + player->nb_chien_card);

  gdk_threads_enter ();

  gtk_layout_get_size (GTK_LAYOUT (gui_layout), &width, &height);

  /* status bar */
  gtk_statusbar_push (GTK_STATUSBAR (gui_statusbar), 0,
		      _("Please, make your chien."));

  /* assign callback functions to cards */
  for (i = 0; i < player->nb_hand_card + player->nb_chien_card; i++)
    {
      if (tot_card.card[i] >= GUI_CARD_IN_CHIEN)
	{
	  click_card[i].tot_card = &tot_card;
	  click_card[i].card = tot_card.card[i] - GUI_CARD_IN_CHIEN;
	  g_signal_connect (G_OBJECT
			    (gui_card_img
			     [tot_card.card[i] - GUI_CARD_IN_CHIEN]),
			    "button-press-event", G_CALLBACK (card_clicked),
			    &click_card[i]);
	}
      else
	{
	  click_card[i].tot_card = &tot_card;
	  click_card[i].card = tot_card.card[i];
	  g_signal_connect (G_OBJECT (gui_card_img[tot_card.card[i]]),
			    "button-press-event", G_CALLBACK (card_clicked),
			    &click_card[i]);
	}
    }


  button_ok = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_widget_size_request (GTK_WIDGET (button_ok), &req);
  gtk_layout_put (GTK_LAYOUT (gui_layout), button_ok,
		  (width - req.width) / 2,
		  height - gui_card_height - 5 * req.height / 2);
  g_signal_connect (G_OBJECT (button_ok), "clicked",
		    G_CALLBACK (ok_seen_chien), NULL);

  gtk_widget_show_all (gui_mainwin);

  gui_set_redraw_func (chien_redraw, &tot_card);
  gui_do_redraw ();

  gdk_threads_leave ();

  done = 0;

  while (done == 0)
    {
      /* put chat part here! */
      usleep (100);
    }

  gdk_threads_enter ();

  gtk_widget_destroy (GTK_WIDGET (button_ok));

  for (i = 0, ih = 0, ic = 0;
       i < player->nb_hand_card + player->nb_chien_card; i++)
    {
      if (tot_card.card[i] >= GUI_CARD_IN_CHIEN)
	{
	  g_signal_handlers_destroy (G_OBJECT
				     (gui_card_img
				      [tot_card.card[i] -
				       GUI_CARD_IN_CHIEN]));
	  player->chien[ic] = tot_card.card[i] - GUI_CARD_IN_CHIEN;
	  ic += 1;
	}
      else
	{
	  g_signal_handlers_destroy (G_OBJECT
				     (gui_card_img[tot_card.card[i]]));
	  player->card[ih] = tot_card.card[i];
	  ih += 1;
	}
    }

  for (i = 0; i < player->nb_chien_card; i++)
    if (player->chien[i] != -1)
      {
	gtk_layout_move (GTK_LAYOUT (gui_layout),
			 gui_card_img[player->chien[i]], X_HIDE, Y_HIDE);
      }

  gdk_threads_leave ();

  return (0);
}




/***********************/
/* Not make chien part */
/***********************/

gint
player_client_not_make_chien (libmt_client_player_t * player)
{
  return (0);
}







/***********************/
/* Wait see chien part */
/***********************/

static void
wait_see_chien_redraw (GtkWidget * win, GdkEventConfigure * evt,
		       gpointer data)
{
  gint width, height;
  GtkRequisition req;
  gfloat px;
  gint i;
  libmt_client_player_t *player = data;

  gui_layout_get_size (evt, &width, &height);

  player_client_redraw_base (win, evt, player);

  gui_sort_card (player->chien, player->nb_chien_card);

  /* display chien cards */
  px = (gfloat) (width - gui_card_width * 2) / (player->nb_hand_card - 1);

  for (i = 0; i < player->nb_chien_card; i++)
    if (player->chien[i] != -1)
      {
	gtk_layout_move (GTK_LAYOUT (gui_layout),
			 gui_card_img[player->chien[i]],
			 (width - px * (player->nb_chien_card - 1) -
			  gui_card_width) / 2 + px * i,
			 height / 2 - gui_card_height);
      }

  gtk_widget_size_request (GTK_WIDGET (button_ok), &req);
  gtk_layout_move (GTK_LAYOUT (gui_layout), button_ok,
		   (width - req.width) / 2,
		   height - gui_card_height - 5 * req.height / 2);

  gtk_widget_queue_resize (GTK_WIDGET (gui_mainwin));
}




void
player_client_wait_see_chien (libmt_client_player_t * player)
{
  gint width, height;
  GtkRequisition req;
  gint i;

  gui_sort_card (player->chien, player->nb_chien_card);

  gdk_threads_enter ();

  gtk_layout_get_size (GTK_LAYOUT (gui_layout), &width, &height);

  button_ok = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_widget_size_request (GTK_WIDGET (button_ok), &req);
  gtk_layout_put (GTK_LAYOUT (gui_layout), button_ok,
		  (width - req.width) / 2,
		  height - gui_card_height - 5 * req.height / 2);
  g_signal_connect (G_OBJECT (button_ok), "clicked",
		    G_CALLBACK (ok_seen_chien), NULL);

  gtk_widget_show_all (gui_mainwin);

  gui_set_redraw_func (wait_see_chien_redraw, player);
  gui_do_redraw ();

  gdk_threads_leave ();

  done = 0;

  while (done == 0)
    {
      /* put chat part here! */
      usleep (100);
    }

  gdk_threads_enter ();

  gtk_widget_destroy (GTK_WIDGET (button_ok));

  for (i = 0; i < player->nb_chien_card; i++)
    if (player->chien[i] != -1)
      {
	gtk_layout_move (GTK_LAYOUT (gui_layout),
			 gui_card_img[player->chien[i]], X_HIDE, Y_HIDE);
      }

  gdk_threads_leave ();
}
