(* Comments system.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: post_comment_form.ml,v 1.8 2004/03/02 16:21:44 rwmj Exp $
 *
 * See examples/comments/README
 *)

open Apache
open Cgi
open Comments

(* Load and compile the template. *)
let template = get_template "post_comment_form.html"

let run r (q : cgi) dbh userid =
  (* Get ID parameter. *)
  let id = int_of_string (q#param "id") in

  (* Get the URI for display. *)
  let sth = dbh#prepare_cached "select uri from comments_pages where id = ?" in
  sth#execute [`Int id];

  let uri = sth#fetch1string () in

  (* Prefill name field, if logged in. *)
  let name =
    if userid > 0 then (
      let sth =
	dbh#prepare_cached "select name from comments_users where id = ?" in
      sth#execute [`Int userid];
      sth#fetch1string ()
    ) else
      "" in

  (* Set the ID and URI in the template. *)
  template#set "id" (string_of_int id);
  template#set "uri" uri;
  template#set "name" name;

  (* Display the page. *)
  q#template template

let () =
  register_script run
