(* Display parameters.
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: params.ml,v 1.3 2004/02/26 12:10:51 rwmj Exp $
 *
 * To get this working you need to locate registry.cmo and create a caml-bin
 * directory containing params.cmo. Then set up Apache like this:
 *
 * CamlLoad /the/path/to/registry.cmo
 * Alias /caml-bin/ /path/to/your/caml-bin/
 * <Location /caml-bin>
 *   SetHandler ocaml-bytecode
 *   CamlHandler Registry.handler
 *   Options ExecCGI
 *   Allow from all
 * </Location>
 *
 * Now point your browser at /caml-bin/params.cmo?test=1 to see this
 * script run. Look for errors in the Apache error log.
 *)

open Apache
open Registry
open Cgi

(* This is the template. Normally, of course, the template should be placed in
 * an external file so that there is a clean separation of code from
 * presentation. But in this instance we include it directly in the script
 * for simplicity of installation.
 *)
let template = "
<html>
 <head><title>::title_html::</title></head>
  <body bgcolor=\"#ffffff\">
  <h1>::title_html::</h1>
  <h2>Parameters passed into the script</h2>
  <table border=\"1\"><tr><th>Name</th><th>Value</th></tr>
   ::table(params)::
   <tr><td>::name_html::</td><td>::value_html::</td></tr>
   ::end::
  </table>
  <h2>Form</h2>
  <p>
   This is a simple form which POSTs data to the script:
  </p>
  <form method=\"post\" action=\"params.cmo\">
   Name: <input name=\"name\" value=\"\">
   <input type=\"submit\" name=\"submit\" value=\"Send\">
  </form>
 </body>
</html>"

(* The template is compiled once when the script is loaded. *)
let template = Template.template_from_string template;;
template#set "title" "Params demonstration CGI script"

let run r =
  let q = new cgi r in

  (* Get each parameter (gets [ name, value; name, value; ... ]). *)
  let params = q#params in
  (* Convert this to a table. *)
  let table =
    List.map (fun (name, value) ->
		[ "name", Template.VarString name;
		  "value", Template.VarString value ]) params in

  (* Set up the table. *)
  template#table "params" table;

  (* Display the page. *)
  q#template template

(* Register the script's run function. *)
let () =
  register_script run
