(* Upload an image (demonstrates use of multipart/form-data).
 * Copyright (C) 2003 Merjis Ltd.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: upload_image.ml,v 1.1 2004/03/05 13:11:01 rwmj Exp $
 *
 * To get this working you need to locate registry.cmo and create a caml-bin
 * directory containing upload_image.cmo. Then set up Apache like this:
 *
 * CamlLoad /the/path/to/registry.cmo
 * Alias /caml-bin/ /path/to/your/caml-bin/
 * <Location /caml-bin>
 *   SetHandler ocaml-bytecode
 *   CamlHandler Registry.handler
 *   Options ExecCGI
 *   Allow from all
 * </Location>
 *
 * Now point your browser at /caml-bin/upload_image.cmo to see this
 * script run. Look for errors in the Apache error log.
 *)

open Apache
open Registry
open Cgi

(* This is the template. Normally, of course, the template should be placed in
 * an external file so that there is a clean separation of code from
 * presentation. But in this instance we include it directly in the script
 * for simplicity of installation.
 *)
let template = "
<html>
 <head><title>::title_html::</title></head>
  <body bgcolor=\"#ffffff\">
  <h1>::title_html::</h1>
  ::if(uploaded)::
  <p>
    File uploaded to <strong>::uploaded_file::</strong> on server.
    You should check that this file matches exactly what you uploaded.
    Original filename was ::uploaded_filename::.
    Original MIME type was ::uploaded_mime_type::.
  </p>
  ::end::
  <h2>Form</h2>
  <form method=\"post\" action=\"upload_image.cmo\"
   enctype=\"multipart/form-data\">
   Image file: <input type=\"file\" name=\"file\" value=\"\">
   <input type=\"submit\" name=\"submit\" value=\"Upload\">
  </form>
 </body>
</html>"

(* The template is compiled once when the script is loaded. *)
let template = Template.template_from_string template;;
template#set "title" "Upload demonstration CGI script"

let run r =
  let q = new cgi r in

  (* Uploading a file/image? *)
  (try
     let upload = q#upload "file" in
     let data = upload.upload_value in
     let original_filename = upload.upload_filename in
     let original_mime_type = upload.upload_content_type in
     let filename, chan = Filename.open_temp_file "upload" ".tmp" in
     output_string chan data;
     close_out chan;
     template#conditional "uploaded" true;
     template#set "uploaded_file" filename;
     template#set "uploaded_filename" original_filename;
     template#set "uploaded_mime_type" original_mime_type
   with
       Not_found ->
	 template#conditional "uploaded" false);

  (* Display the page. *)
  q#template template

(* Register the script's run function. *)
let () =
  register_script run
