--
-- PostgreSQL database dump
--

\connect - rich

SET search_path = public, pg_catalog;

--
-- TOC entry 2 (OID 42722)
-- Name: sections; Type: TABLE; Schema: public; Owner: rich
--

CREATE TABLE sections (
    name text NOT NULL
);


--
-- TOC entry 3 (OID 42722)
-- Name: sections; Type: ACL; Schema: public; Owner: rich
--

REVOKE ALL ON TABLE sections FROM PUBLIC;
GRANT ALL ON TABLE sections TO "www-data";


--
-- TOC entry 4 (OID 42735)
-- Name: cookies; Type: TABLE; Schema: public; Owner: rich
--

CREATE TABLE cookies (
    rand text NOT NULL,
    section text NOT NULL,
    email text NOT NULL,
    entered_time timestamp without time zone DEFAULT ('now'::text)::timestamp(6) with time zone NOT NULL
);


--
-- TOC entry 5 (OID 42735)
-- Name: cookies; Type: ACL; Schema: public; Owner: rich
--

REVOKE ALL ON TABLE cookies FROM PUBLIC;
GRANT ALL ON TABLE cookies TO "www-data";


--
-- TOC entry 6 (OID 42767)
-- Name: users; Type: TABLE; Schema: public; Owner: rich
--

CREATE TABLE users (
    id serial NOT NULL,
    email text NOT NULL
);


--
-- TOC entry 7 (OID 42767)
-- Name: users; Type: ACL; Schema: public; Owner: rich
--

REVOKE ALL ON TABLE users FROM PUBLIC;
GRANT ALL ON TABLE users TO "www-data";


--
-- TOC entry 10 (OID 42767)
-- Name: users_id_seq; Type: ACL; Schema: public; Owner: rich
--

REVOKE ALL ON TABLE users_id_seq FROM PUBLIC;
GRANT ALL ON TABLE users_id_seq TO "www-data";


--
-- TOC entry 8 (OID 42777)
-- Name: subscriptions; Type: TABLE; Schema: public; Owner: rich
--

CREATE TABLE subscriptions (
    userid integer NOT NULL,
    section text NOT NULL
);


--
-- TOC entry 9 (OID 42777)
-- Name: subscriptions; Type: ACL; Schema: public; Owner: rich
--

REVOKE ALL ON TABLE subscriptions FROM PUBLIC;
GRANT ALL ON TABLE subscriptions TO "www-data";


--
-- TOC entry 14 (OID 42790)
-- Name: subscriptions_idx; Type: INDEX; Schema: public; Owner: rich
--

CREATE UNIQUE INDEX subscriptions_idx ON subscriptions USING btree (userid, section);


--
-- TOC entry 11 (OID 42727)
-- Name: sections_pkey; Type: CONSTRAINT; Schema: public; Owner: rich
--

ALTER TABLE ONLY sections
    ADD CONSTRAINT sections_pkey PRIMARY KEY (name);


--
-- TOC entry 15 (OID 42741)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: rich
--

ALTER TABLE ONLY cookies
    ADD CONSTRAINT "$1" FOREIGN KEY (section) REFERENCES sections(name) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 13 (OID 42773)
-- Name: users_pkey; Type: CONSTRAINT; Schema: public; Owner: rich
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- TOC entry 12 (OID 42775)
-- Name: users_email_key; Type: CONSTRAINT; Schema: public; Owner: rich
--

ALTER TABLE ONLY users
    ADD CONSTRAINT users_email_key UNIQUE (email);


--
-- TOC entry 16 (OID 42782)
-- Name: $1; Type: CONSTRAINT; Schema: public; Owner: rich
--

ALTER TABLE ONLY subscriptions
    ADD CONSTRAINT "$1" FOREIGN KEY (userid) REFERENCES users(id) ON UPDATE NO ACTION ON DELETE NO ACTION;


--
-- TOC entry 17 (OID 42786)
-- Name: $2; Type: CONSTRAINT; Schema: public; Owner: rich
--

ALTER TABLE ONLY subscriptions
    ADD CONSTRAINT "$2" FOREIGN KEY (section) REFERENCES sections(name) ON UPDATE NO ACTION ON DELETE NO ACTION;


