(** "Registry" for running OCaml scripts. *)
(*
 * Copyright (C) 2003 Merjis Ltd.
 *
 * $Id: registry.mli,v 1.9 2005/01/05 16:13:28 ChriS Exp $
 *)

open Apache

val return : unit -> 'a
  (** Scripts may call [return ()] at any time which immediately exits
      from the script.  It is actually implemented by throwing [Exit]
      exception which is caught (and ignored) in the registry code.
  *)

val register_script : (Request.t -> unit) -> unit
  (** Scripts must call [register_script fn] once to register their main
      function during initialization.

      The exception [Exit] is caught and ignored (which means you can
      just terminates your script by raising [Exit]).
      {!Apache.HttpError} exceptions are turned into the appropriate
      error code (or HTTP_INTERNAL_SERVER_ERROR if they do not match
      one).  All other exceptions provoke a internal server error and
      are logged in the Apache error log. *)
